% ---
% This script trains similarity measures and evaluates the 
% impact of the number of hidden states as displayed in figure 3 of
% % Feature Preprocessing with RBMs for Music Similarity Learning
% Son N. Tran, Daniel Wolff, Tillman Weyde, Artur Garcez, AES53rd
% conference 
%
% The output is printed in the console and plotted afterwards
% 
% please note that the RBM training is a probabilistic process, and 
% thus the papers' results can only be reproduced approximately with 
% large numbers iterations of this script, and selection of RBMs according to
% their training set performance.
% ---

% this version reproduces the figure approximately using precomputed RBM
[test(1), train(1)] = rbm_fig3('rbm_h30');
[test(2), train(2)] = rbm_fig3('rbm_h50');
[test(3), train(3)] = rbm_fig3('rbm_h100');
[test(4), train(4)] = rbm_fig3('rbm_h500');
[test(5), train(5)] = rbm_fig3('rbm_h1000');

% optionally, in order to test new RBMs, use the code below
% [test(1), train(1)] = rbm_fig3(30);
% [test(2), train(2)] = rbm_fig3(50);
% [test(3), train(3)] = rbm_fig3(100);
% [test(4), train(4)] = rbm_fig3(500);
% [test(5), train(5)] = rbm_fig3(1000);

hidNum = [30 50 100 500 1000];
hFig = figure;
set(hFig,'Units','centimeters');
set(hFig, 'Position', [10 10 10 6]);
plot(hidNum,train*100,'--rx');
hold on
plot(hidNum,test*100,'-bo');
lg = legend('Training','Test');
set(lg,'Location','SouthEast');
title ('Figure 4: GRADIENT results for different hidNum');
