% ---
% This script plots 50-dimensional RBM features as in figure 2 of 
% 
% Feature Preprocessing with RBMs for Music Similarity Learning
% Son N. Tran, Daniel Wolff, Tillman Weyde, Artur Garcez, AES53rd
% conference 
% ---

% cr_: training correct
% cr : testing correct
feature_file = 'rel_music_raw_features+simdata_ISMIR12';
vars = whos('-file', feature_file);
A = load(feature_file,vars(1).name,vars(2).name,vars(3).name,vars(4).name);
raw_features = A.(vars(1).name);
indices      = A.(vars(2).name);
tst_inx      = A.(vars(3).name);
trn_inx      = A.(vars(4).name);
% 
figure(1); imagesc(raw_features);colorbar;
title 'Original Features';

% load pregenerated RBM features
mod = load('rbm_50');

% ---
% uncomment the following line to use newly calculated RBM features
% mod = new_rbm(50,'grad');
% ---

features = logistic(raw_features*mod.W_max{1} + repmat(mod.hB_max{1},size(raw_features,1),1));
figure(2); imagesc(features);colorbar;
title 'RBM Features';

num_case = size(trn_inx,1); 
[trnd_12 trnd_13] = subspace_distances(trn_inx,features,indices,1,1);
[tstd_12 tstd_13] = subspace_distances(tst_inx,features,indices,1,1);
cr_ = 0;   % correct rate for training
cr  = 0;   % correct rate for testing
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
