function observe_reconstruction(Is,num,g,img_row,img_col)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Saving images to files                                             %   
% Is: Images                                                         %
% sNum: Number of images to save                                     %
% g: indices: imaged group gth                                     %
% -*-sontran2012-*-                                                  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if num>100, return; end;
dir = 'C://Pros/tmp/obsv/';
col = floor(sqrt(num));
row = ceil(num/col);
gap = 2;
pos = ones(1,col*row);
pos = cumsum(pos);
pos = vec2mat(pos,col);
bigImg = zeros(row*img_row + (row-1)*gap,col*img_col + (col-1)*gap);
for i=1:row
    for j=1:col
        y = 1 + (i-1)*(img_row+gap);
        x = 1 + (j-1)*(img_col+gap);
        if pos(i,j) <= num, bigImg(y:y+img_row-1,x:(x+img_col-1)) = vec2mat(Is(pos(i,j),:),img_col); end;
    end
end
imwrite(bigImg,strcat(dir,'img_',num2str(g),'.bmp'),'BMP');
end

