function out = s_to_hhmmss(in)
%input: time in s (integer)
%output: string in hhmmss format

hours = div(in,3600);
mins = div(mod(in,3600),60);
secs = mod(in,60);

out = strcat(tostr(hours),tostr(mins),tostr(secs));


function u=tostr(v)
if(v<10)
    u=sprintf('0%d',v);
else
     u=sprintf('%d',v);
end

function u=div(v,w)
u=(floor(v/w));