/*
 * udpClient.cpp
 *
 *  Created on: 19 May 2015
 *      Author: giulio moro
 */
#include "../include/UdpClient.h"

	UdpClient::UdpClient(){
		outSocket=socket(AF_INET, SOCK_DGRAM, 0);
		isSetPort=false;
		isSetServer=false;
		enabled=false;
	}
	UdpClient::UdpClient(int aPort, const char* aServerName){
		outSocket=socket(AF_INET, SOCK_DGRAM, 0);
		if(outSocket<0){
			enabled=false;
			return;
		}
		setPort(aPort);
		setServer(aServerName);
		isSetPort=true;
		isSetServer=true;
		enabled=true;
	}
	UdpClient::~UdpClient(){
	   close(outSocket);
	}
	void UdpClient::setPort(int aPort){
		port=aPort;
		destinationServer.sin_port = htons(port);
		destinationServer.sin_family = AF_INET;
		isSetPort=true;
		if(isSetServer){
			enabled=true;
		}
	};
	void UdpClient::setServer(const char* aServerName){
		inet_pton(AF_INET,aServerName,&destinationServer.sin_addr);
		isSetServer=true;
		if(isSetPort){
			enabled=true;
		}
	};
	int UdpClient::send(void * message, int size){
		if(!enabled)
			return -1;
		unsigned int length;
		length=sizeof(struct sockaddr_in);
		int n=sendto(outSocket,message,size,0,(const struct sockaddr *)&destinationServer,length);
		if (n < 0){
			return n;
		}
		return 1;
	};
	int UdpClient::write(const char* remoteHostname, int remotePortNumber, void* sourceBuffer, int numBytesToWrite){
		setServer(remoteHostname);
		setPort(remotePortNumber);
		send(sourceBuffer, numBytesToWrite);
	}

