#include "../../include/UdpServer.h"
#include "../../include/UdpClient.h"
#include <unistd.h>

int test1(UdpServer *server, UdpClient *client){
	int buffer;
	int tot=100;
	int errors=0;
	for(int n=0; n<tot; n++){
		if(client->send(&n,sizeof(int))!=1){
			printf("error: while sending\n");
			errors++;
		}
	}
	for(int n=0; n<tot; n++){
		if(server->read(&buffer,sizeof(int))<0){
			printf("error: unable to read\n");
			errors++;
			continue;
		};
		if(n!=buffer){
			printf("error: %d!=%d\n",n,buffer);
			errors++;
		}
	}
	int n=server->emptySocket();
	if(n!=0)
		printf("Error: the socket had %d bytes\n",n);
	return errors;
}
int compareStrings(char * str1, char * str2){
	if(strlen(str1)!=strlen(str2))
		return -1;
	for(int n=0; n<strlen(str1); n++){
		if(str1[n]!=str2[n])
			return -1;
	}
	return 0;
}

int test2(UdpServer *server, UdpClient *client){
	char buffer[1000];
	int tot=100;
	int errors=0;
	for(int n=0; n<tot; n++){
		int num=sprintf(buffer,"%08.8f",n/1000.0);
		client->send(&buffer,sizeof(char)*(num+1));
	}
	char auxBuffer[100];
	for(int n=0; n<tot; n++){
		int num=sprintf(auxBuffer,"%08.8f",n/1000.0);
		server->read(&buffer,num*sizeof(char));
		if(compareStrings(auxBuffer,buffer)==-1){
			printf("error: %s!=%s\n",auxBuffer,buffer);
			errors++;
		}
	}

	return errors;
}

int test3(UdpServer *server, UdpClient *client){
	char buffer[1000];
	int tot=100;
	int errors=0;
    int totNum=0;
	for(int n=0; n<tot; n++){
		int num=sprintf(buffer,"%.8f",n/1000.0);
		client->send(&buffer,sizeof(char)*(num+1));
        totNum+=1+num;
	}
    int n=server->emptySocket();
    if(n!=totNum){
        errors=1;
        printf("retrieved bytes differs from sent bytes: %d!=%d\n",n,totNum);
    }
	return errors;
}


int main(){
	int port=1234;
	char serverName[]="127.0.0.1";
	UdpServer server(port);
	UdpClient client(port,serverName);
	int errors=0;
	int ret=0;
	ret=test1(&server,&client);
	errors+=ret;
	if(ret)
		printf("test1 failed with %d errors\n", ret);
	else
		printf("test1 passed\n");

	ret=test2(&server,&client);
	errors+=ret;
	if(ret)
		printf("test2 failed with %d errors\n", ret);
	else
		printf("test2 passed\n");

	ret=test3(&server,&client);
	errors+=ret;
	if(ret)
		printf("test3 failed with %d errors\n", ret);
	else
		printf("test3 passed\n");
//now test if the setPort and setServer methods work
	client.~UdpClient();
	server.~UdpServer();
	port=1235;
	UdpServer server1;
	UdpClient client1;
	client1.setPort(port);
	client1.setServer(serverName);
	if(server1.bindToPort(port)==false){
		printf("unable to bind to port %d\n",port);
		errors+=1;
	}
	ret=test1(&server1, &client1);
	errors+=ret;
	if(ret)
		printf("test1 failed with %d errors\n", ret);
	else
		printf("test1 passed\n");

	return errors;
}
