/*
 * udpClient.cpp
 *
 *  Created on: 19 May 2015
 *      Author: giulio moro
 */
#include "../include/UdpClient.h"

	UdpClient::UdpClient(){
		enabled=false;
	}
	UdpClient::UdpClient(int aPort, const char* aServerName){
		outSocket=socket(AF_INET, SOCK_DGRAM, 0);
		if(outSocket<0){
			enabled=false;
			return;
		}
		setPort(aPort);
		setServer(aServerName);
		enabled=true;
	}
	UdpClient::~UdpClient(){
	   close(outSocket);
	}
	void UdpClient::setPort(int aPort){
		port=aPort;
		destinationServer.sin_port = htons(port);
		destinationServer.sin_family = AF_INET;
	};
	void UdpClient::setServer(const char* aServerName){
		inet_pton(AF_INET,aServerName,&destinationServer.sin_addr);
	};
	int UdpClient::send(void * message, int size){
		if(!enabled)
			return -1;
		unsigned int length;
		length=sizeof(struct sockaddr_in);
		int n=sendto(outSocket,message,size,0,(const struct sockaddr *)&destinationServer,length);
		if (n < 0)
			return n;
		return 1;
	};

