#!/bin/sh
#
# This script enables or disables running Bela when the board starts
# up.

[ -z "$BBB_ADDRESS" ] && BBB_ADDRESS="root@192.168.7.2"
[ -z "$BBB_BELA_HOME" ] && BBB_BELA_HOME="~/Bela/"
[ -z "$BBB_SCREEN_NAME" ] && BBB_SCREEN_NAME="Bela"
[ -z "$RUN_PROJECT" ] && RUN_PROJECT=1
[ -z "$COMMAND_ARGS" ] && COMMAND_ARGS=
[ -z "$RUN_IN_FOREGROUND" ] && RUN_IN_FOREGROUND=1
[ -z "$RUN_WITHOUT_SCREEN" ] && RUN_WITHOUT_SCREEN=0
[ -z "$BBB_PROJECT_HOME" ] && BBB_PROJECT_HOME="${BBB_BELA_HOME}/projects/"
[ -z "$BBB_DEFAULT_PROJECT_NAME" ] && BBB_DEFAULT_PROJECT_NAME="scriptUploadedProject"
[ -z "$BBB_PROJECT_NAME" ] && BBB_PROJECT_NAME=$BBB_DEFAULT_PROJECT_NAME
ENABLE_STARTUP=1
RUN_IN_LOOP=0

# This path is hard-coded in the Bela image at present.

usage()
{
    THIS_SCRIPT=`basename "$0"`
    echo "Usage: $THIS_SCRIPT [-b path-on-beaglebone] [-c command-line-args] [-n] [-l]"

    echo "
    This script enables (by default) or disables running the Bela
    project at startup. The -n option disables auto-startup, otherwise
    auto-startup is enabled. The -b option changes the name of the project to
    set on startup, which is otherwise $BBB_DEFAULT_PROJECT_NAME. The -c option 
    passes command-line arguments to the Bela program; enclose the argument 
    string in quotes.
    The -l option runs the Bela program in a loop, restarting
    automatically in the event of a crash."
}

OPTIND=1

while getopts "b:c:nlh" opt; do
    case $opt in
        b)            BBB_PROJECT_NAME=$OPTARG
                      ;;
        c)            COMMAND_ARGS=$OPTARG
                      ;;
        n)            ENABLE_STARTUP=0
                      ;;
        l)            RUN_IN_LOOP=1
                      ;;
        h|\?)         usage
                      exit 1
    esac
done

shift $((OPTIND-1))

MAKE_COMMAND="make --no-print-directory -C $BBB_BELA_HOME PROJECT=$BBB_PROJECT_NAME CL=\"$OPTARG\""
if [ $ENABLE_STARTUP -eq 0 ]
then
    ssh $BBB_ADDRESS "$MAKE_COMMAND nostartup"
elif [ $RUN_IN_LOOP -eq 1 ]
then    
    ssh $BBB_ADDRESS "$MAKE_COMMAND startuploop" 
else 
    ssh $BBB_ADDRESS "$MAKE_COMMAND startup" 
fi
