/*
 *  RTAudio.h
 *
 *  Central control code for hard real-time audio on BeagleBone Black
 *  using PRU and Xenomai Linux extensions. This code began as part
 *  of the Hackable Instruments project (EPSRC) at Queen Mary University
 *  of London, 2013-14.
 *
 *  (c) 2014 Victor Zappi and Andrew McPherson
 *  Queen Mary University of London
 */


#ifndef RTAUDIO_H_
#define RTAUDIO_H_

#include "render.h"

// Useful constants
#define DBOX_CAPE					// New custom cape

#ifdef DBOX_CAPE
#define CODEC_I2C_ADDRESS  0x18		// Address of TLV320AIC3104 codec
#else
#define CODEC_I2C_ADDRESS  0x1B		// Address of TLV320AIC3106 codec
#endif

enum {
	kAmplifierMutePin = 61	// P8-26 controls amplifier mute
};

typedef void* AuxiliaryTask;	// Opaque data type to keep track of aux tasks

// Flag that indicates when the audio will stop; can be read or
// set by other components which should end at the same time as the audio
extern bool gShouldStop;

int initAudio(int periodSize, int useMatrix, void *userData,
			  int codecI2CAddress = CODEC_I2C_ADDRESS, int ampMutePin = kAmplifierMutePin);
int startAudio();
void stopAudio();
void cleanupAudio();

AuxiliaryTask createAuxiliaryTaskLoop(void (*functionToCall)(void), int priority, const char *name);
void scheduleAuxiliaryTask(AuxiliaryTask task);

void setVerboseLevel(int level);

#endif /* RTAUDIO_H_ */
