/*
 * intervals.h
 *
 *  Created on: 18 May 2015
 *      Author: unmanaged
 */

#ifndef INTERVALS_H_
#define INTERVALS_H_

#define TEN_POW_9 1000000000

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#include <native/timer.h>
#include <rtdk.h>

class Interval
{
	private:
		int intervalsPointer;
		long sum;
		RTIME startTime;
		RTIME *intervals;
		float maxTimeus;
		float timeus;
		float samplingRate; //used for getPrint()
		int numFrames;
		bool enabled; //whether it actually reads the clock or not
		int numAverages;
		char *name;
		void init(int aNumAverages, int aNumFrames, float aSamplingRate, const char *aName);
	public:
		Interval();
		Interval(int aNumAverages);
		Interval(int aNumAverages, int aNumFrames, float aSamplingRate, const char *aName);
		~Interval();
		void setNumFrames(int aNumFrames);
		int start();
		int resetMax();
		int split();
		void setEnabled(bool aActive);
		float getTimeus();
		float getMaxTimeus();
		void print();
};

#endif /* INTERVALS_H_ */
