#ifndef VIRTUAL_CLOCK_H_INCLUDED
#define VIRTUAL_CLOCK_H_INCLUDED

#include "math.h"
#include "stats.hpp"
#include "Clock.h"
#ifdef USE_JUCE
#else
#include <BeagleRT.h>
#endif /* USE_JUCE */

class VirtualClock{
private:
	myClock_t startTime;
	myClock_t startTimeOffset;
	myClock_t lastSync;
	bool firstRun;
	double elapsedPeriods;
	double elapsedPeriodsOffset;
	double period;
	MovingAverage<double> movingAverage;
public:
	void init();
	VirtualClock();
/**
	Call this method at regular intervals to sync che virtual clock
*/
	void sync();
/**
	Call this method asynchronously, passing a number of equally spaced events that have elapsed since the last call.
*/
	void sync(double numPeriods);
/**
	Get the current time according to the VirtualClock.
	
	@return Time elapsed since the first call to sync(), in period units. 
*/
	double getNow();
/** 
	Get the length of the period.
	
	Get the length of the period (difference between calls to sync() after various filtering operations)
*/
	double getPeriod();
/**
 * Add an offset to the number of elapsed periods.
 *
 * Add an offset to the number of elapsed periods. It also compensates for the corresponding time offset.
 */
	void addOffset(double periodOffset);
};

#endif /* VIRTUAL_CLOCK_H_INCLUDED */
