/*
 * ClockSynchronizer.h
 *
 *  Created on: 26 Aug 2015
 *      Author: giulio
 */

#ifndef CLOCKSYNCHRONIZER_H_
#define CLOCKSYNCHRONIZER_H_

#include <BeagleRT.h>
#include <I2c_Codec.h>
#include <NetworkSend.h>
#include <native/timer.h>
extern I2c_Codec *gAudioCodec;

class ClockSynchronizer {
private:
	int localOffset;
	int remoteOffset;
	RTIME timeOffset;
	int localCounter;
	int remoteCounter;
	RTIME lastTime;
	void reset();
	static bool staticConstructed;
	static void staticConstructor();
	static float currentSamplingRate;
	static float targetSamplingRate;
	static bool threadRunning;
	static int threadWasRunning;
	static AuxiliaryTask setClockTask;
public:
	ClockSynchronizer();
	~ClockSynchronizer();
	void setup();
	void update(int aLocalCounter, int aRemoteCounter, RTIME aLastTime);
	void adjustClock();
	static void setClock();
};

#endif /* CLOCKSYNCHRONIZER_H_ */
