#ifndef CLOCK_SYNC_THREAD_H_INCLUDED
#define CLOCK_SYNC_THREAD_H_INCLUDED

#ifdef USE_JUCE
#include <JuceHeader.h>
#define IS_STATIC
#else
#define IS_STATIC static
#include <BeagleRT.h>
#endif /*USE_JUCE*/

#include "ClockSync.h"

#ifdef USE_JUCE
class ClockSyncThread : public Thread {
#else
class ClockSyncThread {
#endif /* USE_JUCE */
private:
	IS_STATIC myClock_t lastTime; // Used for clock synchronization
	IS_STATIC bool listening;
	IS_STATIC ClockSync clockSync;
	IS_STATIC VirtualClock *virtualClock;
#ifdef USE_JUCE
#else
	IS_STATIC bool threadIsExiting;
	IS_STATIC AuxiliaryTask clockSyncTask;
#endif /* USE_JUCE */

public:
#ifdef USE_JUCE
    ClockSyncThread(const String &threadName);
#else
    ClockSyncThread();
#endif /* USE_JUCE */
    ~ClockSyncThread();
    IS_STATIC void init(bool isSlave, int aPort, VirtualClock &aVirtualClock);
    IS_STATIC void setVirtualClock(VirtualClock &aVirtualClock);

    IS_STATIC void run();
#ifdef USE_JUCE
#else
    IS_STATIC void startThread();
    IS_STATIC void stopThread();
    IS_STATIC bool threadShouldExit();
#endif // USE_JUCE
};
#endif  // CLOCK_SYNC_THREAD_H_INCLUDED
