#ifndef CLOCK_SYNC_H_INCLUDED
#define CLOCK_SYNC_H_INCLUDED
#include "stats.hpp"
#include "UdpServer.h"
#include "UdpClient.h"
#include "Clock.h"
#include "VirtualClock.h"

enum ptpMessageConsts{
	kSyncMessageLength=sizeof(myClock_t)+sizeof(int)
};
enum ptpMessageType{
	kSync=0,
	kFollowUp=1,
	kDelayReq=2,
	kDelayResp=3,
	kNone=4
};

enum ptpStatus{
	kSyncSent,
	kFollowUpSent,
	kDelayReqSent,
	kDelayRespSent
};

class ClockSync{
private:
	MovingAverage<double> movingAverage;
	UdpServer server;
	UdpClient client;
	bool slave;
	int bufferLength;
	int clockSyncType;
	int expectedClockSyncType;
	myClock_t clockSyncTimestamp;
	myClock_t localTimestamp;
	myClock_t T1;
	myClock_t T1p;
	myClock_t T2;
	myClock_t T2p;
	int receiveLoopSleepUs;
	int receiveLoopTimeout;
	char buffer[kSyncMessageLength];
	VirtualClock *virtualClock;
	void resetTs();
	bool areTsValid();
	void processOffset(double offset);
public:
	ClockSync(){};
	ClockSync(bool thisIsSlave, int aPort, VirtualClock &aVirtualClock);
	void init(bool thisIsSlave, int aPort, VirtualClock &aVirtualClock);
	void* getBuffer();
	bool isSlave();
	bool isMaster();
	int getType();
	myClock_t getTimestamp();
	void setVirtualClock(VirtualClock &aVirtualClock);
	void setPort(int aPort);
	void setType(int clockSyncType);
	void setTimestamp(myClock_t timestamp);
	void print();
	/** 
	 * sends a clockSync without blocking, checks results and returns the timestamp
	 * immediately after the clockSync has been sent or -1 if there was an error or timeout expired.
	*/
	myClock_t send();
	/** 
	 * receives a clockSync without blocking, checks results and returns the timestamp
	 * immediately after the clockSync has been received, or -1 if there was an error 
	 * or 0 if timeout expired.
	*/
	myClock_t receive();
	int masterSendSync();
	int receiveLoop();
	int slaveHandleMessage();
	int masterHandleMessage();
	int sendReceiveLoop();
	operator void*(){
	return getBuffer();
	}
};

#endif /* CLOCK_SYNC_H_INCLUDED */
