/*
 * intervals.h
 *
 *  Created on: 18 May 2015
 *      Author: unmanaged
 */

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#include <native/timer.h>
#include <rtdk.h>

#include "../include/intervals.h"
void Interval::init(int aNumAverages, int aNumFrames, float aSamplingRate, const char *aName){
	enabled=false;
	numAverages=aNumAverages;
	intervals=(RTIME *)malloc(sizeof(RTIME)*numAverages);
	samplingRate=aSamplingRate;
	numFrames=aNumFrames;
	maxTimeus=0;
	intervalsPointer=0;
	sum=0;
	startTime=0;

	if(intervals!=0)
		enabled=true;
	int len=strlen(aName);
	name=(char *)malloc(sizeof(char)*(len+1));
	strcpy(name, aName);
	if(name == 0)
		enabled=false;
};
Interval::Interval(){
	init(100,1,44100,"");
}
Interval::Interval(int aNumAverages){
	init(aNumAverages,1,44100,"");
}
Interval::Interval(int aNumAverages, int aNumFrames, float aSamplingRate, const char *aName){
	init(aNumAverages,aNumFrames,aSamplingRate,aName);
}
Interval::~Interval(){
	free(intervals);
//			free(name);
}
void Interval::setNumFrames(int aNumFrames){
	numFrames=aNumFrames;
};

int Interval::start(){
//	printf("start: intervals: 0x%x, intervalsPointer: %d, numAverages: %d\n", intervals,intervalsPointer,numAverages);
	if(!enabled)
		return 0;
	startTime=rt_timer_read();
	return 1;
}
int Interval::resetMax(){
	maxTimeus=0;
	return 1;
}
int Interval::split(){ //updates
	if(!enabled)
		return 0;
	int currentInterval=rt_timer_read()-startTime;
	RTIME *currentPointer=&(intervals[intervalsPointer]);
	sum-=*currentPointer; //take out the oldest value from the sum
	*currentPointer=currentInterval;
	sum+=*currentPointer; //add the new value to the sum
	timeus=((float)sum)/numAverages/1000.0;
	maxTimeus=timeus>maxTimeus?timeus:maxTimeus;
	intervalsPointer++;
	if(intervalsPointer>=(numAverages-1)){
		intervalsPointer=0;
	}
	return 1;
}
void Interval::setEnabled(bool aActive){
	enabled=aActive;
}
float Interval::getTimeus(){
	return timeus;
}
float Interval::getMaxTimeus(){
	return maxTimeus;
}
void Interval::print(){
	rt_printf(//"sleepTimer time: 29.484us, (1.30 samples, numFrames: 2, 65.01%%). MaxTime: 30.439us, (1.34 samples, 67.12%%)\n");
"%s time: %.3fus, (%.2f samples, numFrames: %d, %.2f%%). MaxTime: %.3fus, (%.2f samples, %.2f%%)\n",
			name,
			timeus, timeus/1000000.0*samplingRate, numFrames, timeus/1000000.0*samplingRate/numFrames * 100,
			maxTimeus, maxTimeus/1000000.0*samplingRate, maxTimeus/1000000.0*samplingRate/numFrames * 100);
}
