#!/bin/bash
#
# This script stops the BeagleRT program running on the BeagleBone.

BBB_ADDRESS="root@192.168.7.2"
BBB_SCREEN_NAME="BeagleRT"
# The first command should be sufficient to stop any BeagleRT run with
# these scripts; the second will catch any leftovers run other ways

BELA_AUDIO_THREAD_NAME=beaglert-audio 
ssh $BBB_ADDRESS 'screen -X -S '"$BBB_SCREEN_NAME"' quit > /dev/null; PID=`grep '"$BELA_AUDIO_THREAD_NAME"' /proc/xenomai/stat | cut -d " " -f 5 | sed s/\s//g`; if [ -z $PID ]; then printf ""; else echo "Killing old Bela process $PID"; kill -2 $PID; fi'
