/*
 * RTaudioSettings.h
 *
 *  Created on: 6 May 2015
 *      Author: unmanaged
 */

#ifndef RTAUDIOSETTINGS_H_
#define RTAUDIOSETTINGS_H_

#define MAX_PRU_FILENAME_LENGTH 256
#define MAX_SERVERNAME_LENGTH 256
// Structure which contains initialisation parameters for the
// real-time audio system
typedef struct {
	// These items might be adjusted by the user:
	int periodSize;			// Number of (analog) frames per period; audio is twice this
	int beginMuted;			// Whether to begin with the speakers muted
	float dacLevel;			// Level for the audio DAC output
	float adcLevel;			// Level for the audio ADC input
	float headphoneLevel;	// Level for the headphone output
	int useAnalog;			// Whether to use the analog
	int useDigital;		// Whether to use the 16 programmable GPIOs
	int numAnalogChannels;	// How many channels for the ADC and DAC
	int numDigitalChannels;	// How many channels for the GPIOs
	int verbose;			// Whether to use verbose logging
	char pruFilename[MAX_PRU_FILENAME_LENGTH]; //the external .bin file to load. If empty will use PRU code from pru_rtaudio_bin.h
	// These items are hardware-dependent and should only be changed
	// to run on different hardware
	int codecI2CAddress;	// Where the codec can be found on the I2C bus
	int ampMutePin;			// Pin where amplifier mute can be found
	int receivePort;          //port where the UDP server will listen
	int transmitPort;         //port where the UDP client will transmit
	char serverName[MAX_SERVERNAME_LENGTH];
} RTAudioSettings;




#endif /* RTAUDIOSETTINGS_H_ */
