/*
 * render.cpp
 *
 *  Created on: Oct 24, 2014
 *      Author: parallels
 */

#include "../../include/RTAudioSettings.h"
#include "../../include/render.h"
#include <cmath>
#include "../../include/client.h"
#include "../../include/RTAudio.h"	// to schedule lower prio parallel process
#include <rtdk.h>
float gFrequency;
float gPhase;
float gInverseSampleRate;
int gCount=0;
networkData networkObject;
AuxiliaryTask transmitReceiveDataTask;

void transmitReceiveData(){
   	printf("transmitReceiveData auxiliary task has started\n");
	while(!gShouldStop){
		sendMessage(networkObject);
		receiveMessage(networkObject);
		usleep(1000);
	}
	closeSockets();
}

// initialise_render() is called once before the audio rendering starts.
// Use it to perform any initialisation and allocation which is dependent
// on the period size or sample rate.
//
// userData holds an opaque pointer to a data structure that was passed
// in from the call to initAudio().
//
// Return true on success; returning false halts the program.
bool initialise_render(int numMatrixChannels, int numDigitalChannels, int numAudioChannels,
					   int numMatrixFramesPerPeriod,
					   int numAudioFramesPerPeriod,
					   float matrixSampleRate, float audioSampleRate,
					   void *userData, RTAudioSettings *settings)
{
	// Retrieve a parameter passed in from the initAudio() call
	gFrequency = *(float *)userData;

	gInverseSampleRate = 1.0 / audioSampleRate;
	gPhase = 0.0;

	networkObject.counter=&gCount;
	networkObject.variables[0]=&gFrequency;
	networkObject.variables[1]=&gPhase;
	networkObject.numVariables=2;
	setupSockets(settings->receivePort, settings->transmitPort, settings->serverName);
	transmitReceiveDataTask=createAuxiliaryTaskLoop(*transmitReceiveData, 80, "transmit-receive-data");
	//scheduleAuxiliaryTask(transmitReceiveDataTask); //here it does not work
	return true;
}

// render() is called regularly at the highest priority by the audio engine.
// Input and output are given from the audio hardware and the other
// ADCs and DACs (if available). If only audio is available, numMatrixFrames
// will be 0.

void render(int numAnalogFrames, int numAudioFrames, int numDigitalFrames, float *audioIn, float *audioOut,
		float *analogIn, float *analogOut, uint32_t *digital)
{
	for(int n = 0; n < numAudioFrames; n++) {
		float out = 0.7f * sinf(gPhase);
		gPhase += 2.0 * M_PI * gFrequency * gInverseSampleRate;
		if(gPhase > 2.0 * M_PI)
			gPhase -= 2.0 * M_PI;

		for(int channel = 0; channel < gNumAudioChannels; channel++)
			audioOut[n * gNumAudioChannels + channel] = out;
		if(gCount==0){
			scheduleAuxiliaryTask(transmitReceiveDataTask);
		}
		gCount++;
	}
}

// cleanup_render() is called once at the end, after the audio has stopped.
// Release any resources that were allocated in initialise_render().

void cleanup_render()
{
}
