//scope.cpp
#ifndef SCOPE_H_
#define SCOPE_H_

#include <BeagleRT.h> 
#include <rtdk.h>
#include <cmath>
#include <UdpClient.h>

#define BUILD_FOR_UDPRECEIVE_PLUGIN
#define NETWORK_AUDIO_BUFFER_SIZE 302

struct NetworkBuffer{
	int timestamp;
	int channelNumber;
	int activeBuffer;
	int index;
	float buffers[2][NETWORK_AUDIO_BUFFER_SIZE]; 
	bool doneOnTime;
	bool readyToBeSent;
	int headerLength=2;
	UdpClient udpClient;
};

#define NUM_SCOPE_CHANNELS 6

class NetworkIO {
    int sampleCount; 
    float sampleRate;
    AuxiliaryTask scopeTask;
    int port;
  public:
    NetworkBuffer channel;
    NetworkIO();
    ~NetworkIO();
    void setup(float aSampleRate);
    void setup(float aSampleRate, int aChannelNumber);
    void sendData();
    void log(float value);
    void setPort(int aPort);
    int getPort();
    void setChannelNumber(int aChannelNumber);
    int getChannelNumber();
};

class Scope {
	NetworkIO *channels;
	int numChannels;
	void deallocate();
public:
	Scope(int aNumChannels);
	~Scope();
	void log(int channel, float value);
    void setup(float sampleRate);
    void sendData();
};
#endif /* SCOPE_H */
