/* UDP client in the internet domain */
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "UdpClient.h"

struct networkData{
	int *counter;
	float *variables[16];
	int numVariables;
};
#define NETWORK_AUDIO_BUFFER_SIZE 100 //1400/4 //maximum payload for a UDP datagram over ethernet is 1472 bytes, I leave some headroom and divide by 4 to get the number of floats
struct networkAudio{
	int timestamp;
	int currentBuffer;
	int index;
	float buffers[2][NETWORK_AUDIO_BUFFER_SIZE];
	int doneOnTime;
	bool toBeSent;
	UdpClient udpClient;
};

void error(const char *);
int setupSockets(int receivePort, int transmitPort, char const*serverName);
int sendMessage(networkData message);
int sendAudio(networkAudio *audio);
int receiveMessage(networkData message);
void closeSockets();
