//scope.cpp
#ifndef SCOPE_H_
#define SCOPE_H_

#include <BeagleRT.h> 
#include <rtdk.h>
#include <cmath>
#include <UdpClient.h>
#include <vector>

#define NETWORK_AUDIO_BUFFER_SIZE 302

struct NetworkBuffer{
	int channelNumber;
	int activeBuffer;
	int index;
	float buffers[2][NETWORK_AUDIO_BUFFER_SIZE];
	bool doneOnTime;
	bool readyToBeSent;
	static const int headerLength=2;
};

class NetworkSend {
    int sampleCount; 
    float sampleRate;
	UdpClient udpClient;
	static bool staticConstructed;
    static void staticConstructor();
    static AuxiliaryTask sendDataTask; //TODO: allow different AuxiliaryTasks for different priorities (e.g.: audio vs scope)
    static std::vector<NetworkSend *> objAddrs;
  public:
    NetworkBuffer channel;
    NetworkSend();
    ~NetworkSend();
    void setup(float aSampleRate);
    void setup(float aSampleRate, int aChannelNumber, int aPort, const char *aServer);
    void sendData();
    void log(float value);
    void setPort(int aPort);
    void setServer(const char* aServer);
    void setChannelNumber(int aChannelNumber);
    int getChannelNumber();
    static int getNumInstances();
    static void sendAllData();
};

/**
 * An array of NetworkSend objects with some default parameters
 *
 * All sending on the same port (defaults to 9999)
 * All sending to the same server (defaults to 127.0.0.1)
*/
class Scope {
	std::vector<NetworkSend> channels;
	void deallocate();
public:
	Scope(int aNumChannels);
	~Scope();
	void log(int channel, float value);
    void setup();
    void setup(float sampleRate, int aPort, const char* aServer);
    void sendData();
    void setPort();
    int getNumChannels();
};
#endif /* SCOPE_H */
