/*
 * render.cpp
 *
 *  Created on: Oct 24, 2014
 *      Author: parallels
 */

#include <BeagleRT.h>
#include <cmath>
#include <client.h>

float gFrequency;
float gPhase;
float gInverseSampleRate;
int gCount=0;
networkData networkObject;
AuxiliaryTask transmitReceiveDataTask;

void transmitReceiveData(){
   	printf("transmitReceiveData auxiliary task has started\n");
	while(!gShouldStop){
		sendMessage(networkObject);
		receiveMessage(networkObject);
		usleep(1000);
	}
	closeSockets();
}

// setup() is called once before the audio rendering starts.
// Use it to perform any initialisation and allocation which is dependent
// on the period size or sample rate.
//
// userData holds an opaque pointer to a data structure that was passed
// in from the call to initAudio().
//
// Return true on success; returning false halts the program.
bool setup(BeagleRTContext *context, void *userData)
{
	// Retrieve a parameter passed in from the initAudio() call
	gFrequency = *(float *)userData;

	gInverseSampleRate = 1.0 / context->audioSampleRate;
	gPhase = 0.0;

	networkObject.counter=&gCount;
	networkObject.variables[0]=&gFrequency;
	networkObject.variables[1]=&gPhase;
	networkObject.numVariables=2;

	setupSockets(settings->receivePort, settings->transmitPort, settings->serverName);
	transmitReceiveDataTask= BeagleRT_createAuxiliaryTask(*transmitReceiveData, 80, "transmit-receive-data");
	//scheduleAuxiliaryTask(transmitReceiveDataTask); //here it does not work
	return true;
}

// render() is called regularly at the highest priority by the audio engine.
// Input and output are given from the audio hardware and the other
// ADCs and DACs (if available). If only audio is available, numMatrixFrames
// will be 0.

void render(BeagleRTContext *context, void *userData)
{
	for(unsigned int n = 0; n < context->audioFrames; n++) {
		float out = 0.7f * sinf(gPhase);
		gPhase += 2.0 * M_PI * gFrequency * gInverseSampleRate;
		if(gPhase > 2.0 * M_PI)
			gPhase -= 2.0 * M_PI;

		for(unsigned int channel = 0; channel < context->audioChannels; channel++)
			context->audioOut[n * context->audioChannels + channel] = out;

		if(gCount == 0){
			BeagleRT_scheduleAuxiliaryTask(transmitReceiveDataTask);
		}
		gCount++;
	}
}

// cleanup() is called once at the end, after the audio has stopped.
// Release any resources that were allocated in setup().

void cleanup(BeagleRTContext *context, void *userData)
{
}
