/*
 * render.cpp
 *
 *  Created on: Oct 24, 2014
 *      Author: parallels
 */


#include "../../include/render.h"
#include "../../include/Utilities.h"
#include <rtdk.h>

// initialise_render() is called once before the audio rendering starts.
// Use it to perform any initialisation and allocation which is dependent
// on the period size or sample rate.
//
// userData holds an opaque pointer to a data structure that was passed
// in from the call to initAudio().
//
// Return true on success; returning false halts the program.

bool initialise_render(int numMatrixChannels, int numAudioChannels,
					   int numMatrixFramesPerPeriod,
					   int numAudioFramesPerPeriod,
					   float matrixSampleRate, float audioSampleRate,
					   void *userData)
{
	// Nothing to do here...

	return true;
}

// render() is called regularly at the highest priority by the audio engine.
// Input and output are given from the audio hardware and the other
// ADCs and DACs (if available). If only audio is available, numMatrixFrames
// will be 0.

void render(int numMatrixFrames, int numAudioFrames, float *audioIn, float *audioOut,
			uint16_t *matrixIn, uint16_t *matrixOut)
{
	// Simplest possible case: pass inputs through to outputs
	for(int n = 0; n < numAudioFrames; n++) {
		for(int ch = 0; ch < gNumAudioChannels; ch++)
			audioOut[n * gNumAudioChannels + ch] = audioIn[n * gNumAudioChannels + ch];
	}

	// Same with matrix, only if matrix is enabled
	if(numMatrixFrames != 0) {
		for(int n = 0; n < numMatrixFrames; n++) {
			for(int ch = 0; ch < gNumMatrixChannels; ch++) {
				// Two equivalent ways to write this code
				// The long way, using the buffers directly:
				// matrixOut[n * gNumMatrixChannels + ch] = matrixIn[n * gNumMatrixChannels + ch];

				// Or using the macros:
				analogWrite(ch, n, analogRead(ch, n));
			}
		}
	}
}

// cleanup_render() is called once at the end, after the audio has stopped.
// Release any resources that were allocated in initialise_render().

void cleanup_render()
{

}
