/*
 * Utilities.h
 *
 *  Created on: Oct 27, 2014
 *      Author: parallels
 */

#ifndef UTILITIES_H_
#define UTILITIES_H_

#include "BeagleRT.h"

#define setBit(word,bit) 			((word) | (1 << (bit)))
#define clearBit(word,bit) 			((word) &~ (1 << (bit)))
#define getBit(word,bit) 			(((word) >> (bit)) & 1)
#define changeBit(word,bit,value) 	((clearBit((word),(bit))) | ((value) << (bit)))

#if 1
// Note: pinMode(), analogWrite() and digitalWrite() should be able to be called from initialise_render()
// Likewise, thread launch should be able to be called from initialise_render()
// Also, make volume change functions callable from render() thread -- as an aux task?

float analogReadFrame(BeagleRTContext *context, int frame, int channel);
void analogWriteFrame(BeagleRTContext *context, int frame, int channel, float value);
void analogWriteFrameOnce(BeagleRTContext *context, int frame, int channel, float value);

int digitalReadFrame(BeagleRTContext *context, int frame, int channel);
void digitalWriteFrame(BeagleRTContext *context, int frame, int channel, int value);
void digitalWriteFrameOnce(BeagleRTContext *context, int frame, int channel, int value);

void pinModeFrame(BeagleRTContext *context, int frame, int channel, int mode);
void pinModeFrameOnce(BeagleRTContext *context, int frame, int channel, int mode);

#else

// Macros for accessing the analog values: usable _only_ within render()

// Read an Analog input from input pin p at frame f
#define analogRead(p, f) (analogIn[(f)*gNumAnalogChannels + (p)])
// Write an Analog output frame at output pin p, frame f, to value v
#define analogWriteFrame(p, f, v) (analogOut[(f)*gNumAnalogChannels + (p)] = (v))
#define analogWrite(pin, frame, value) \
(({do {\
	for (int _privateI=(frame); _privateI<numAnalogFrames; _privateI++){ \
		analogWriteFrame(pin,_privateI,value); \
	}\
	} while (0);}),(void)0)\


//digital API:
#define setDigitalDirectionFrame(pin,frame,direction) digital[(frame)]=changeBit(digital[(frame)],(pin),(direction)),void(0)
#define setDigitalDirection(pin,frame,direction)\
		(({do {\
			for(int _privateI=(frame); _privateI<numDigitalFrames; _privateI++)\
				setDigitalDirectionFrame(pin,_privateI,direction);\
			} while (0);}), (void)0)
#define digitalWriteAll(frame,value) digital[(frame)]=0xffff0000*(!(!value));
//sets the bit in the high word, clears the bit in the low word (just in case the direction was not previously set)
#define digitalWriteFrame(pin, frame, value) digital[(frame)]=( changeBit(digital[(frame)], (pin+16), (value)) & (0xffffffff-(1<<(pin))) ) //could have been done with two subsequent assignments
#define digitalWrite(pin, frame, value) \
	(({do {\
		for (int _privateI=(frame); _privateI<numDigitalFrames; _privateI++) \
			digitalWriteFrame(pin,_privateI,value); \
		} while (0);}),(void)0)\

#define digitalRead(pin, frame) ( getBit(digital[(frame)], pin+16) )

#endif

float map(float x, float in_min, float in_max, float out_min, float out_max);
float constrain(float x, float min_val, float max_val);

#endif /* UTILITIES_H_ */
