#include "ClockSyncThread.h"
#ifdef USE_JUCE
#else //declare static members TODO: rather refactor this similar to other threads so that only run and clockSyncTask are static
	myClock_t ClockSyncThread::lastTime; // Used for clock synchronization
	bool ClockSyncThread::listening;
	ClockSync ClockSyncThread::clockSync;
	VirtualClock* ClockSyncThread::virtualClock;
	bool ClockSyncThread::threadIsExiting;
	AuxiliaryTask ClockSyncThread::clockSyncTask;
#endif
#ifdef USE_JUCE
ClockSyncThread::ClockSyncThread(const String &threadName) :
			Thread(threadName)
#else
ClockSyncThread::ClockSyncThread()
#endif /* USE_JUCE */
{
};
ClockSyncThread::~ClockSyncThread(){
#ifdef USE_JUCE
	stopThread(1000);
#else
	stopThread();
#endif /* USE_JUCE */
}
void ClockSyncThread::init(bool isSlave, int aPort, VirtualClock &aVirtualClock){
	setVirtualClock(aVirtualClock);
	listening=false;
	clockSync.init(isSlave, aPort, *virtualClock);
#ifdef USE_JUCE
	startThread(5);
#else
	threadIsExiting=false;
	clockSyncTask=BeagleRT_createAuxiliaryTask(&ClockSyncThread::run,60, "clockSyncTask");
	//TODO: the thread cannot be started here at the moment because init() is called in setup(), where tasks cannot be scheduled
#endif /* USE_JUCE */
}

#ifdef USE_JUCE
#else
void ClockSyncThread::startThread(){
	BeagleRT_scheduleAuxiliaryTask(clockSyncTask);
}
void ClockSyncThread::stopThread(){
	threadIsExiting=true;
}
bool ClockSyncThread::threadShouldExit(){
	return(gShouldStop || threadIsExiting );
}
#endif /* USE_JUCE */

void ClockSyncThread::setVirtualClock(VirtualClock &aVirtualClock){
	virtualClock=&aVirtualClock;
};

void ClockSyncThread::run(){
	printf("var=[");
	while(!threadShouldExit()){
		clockSync.sendReceiveLoop();
//		double now=virtualClock->getNow();
//		printf("th(end+1)=%f;\n", now);
//		printf("act(end+1)=%lld;\n", Clock::getTimeUs());
	}
	printf("];\n");
//	printf("Thread is not running \n");
}
