#include "Clock.h"

namespace Clock
{
#ifdef USE_JUCE
	myClock_t getTimeUs(){
		struct timeval tv;
		struct timezone tz;
		int ret=gettimeofday(&tv, &tz);
		if(ret == -1){
			printf("Error while getting time of the day\n");
			return -1;
		}
		myClock_t time=tv.tv_usec + tv.tv_sec*1e6;
		//   printf("Time is: %.6f\n", time/1000000.0);
		//   printf("Time is: %lld\n", time);
		return time;
	}
#else
	myClock_t getTimeUs(){
		return (myClock_t)((rt_timer_read()+500)/1000);
	}
#endif /* USE_JUCE */
};
