#!/bin/bash

# shell script for automatic uploading/compiling of pd patch onto bbb
# Christian Heinrichs 2015
#
# example usage: sh upload-and-compile.sh -f bwg-tests -q -e

workingdir=".."
verbose="0"
render="0"
pdpath=""
projectpath="../projects/heavy/hvtemp"
BBB_PATH="~/BeagleRT"
BBB_ADDRESS="root@192.168.7.2"
COMMAND_ARGS=
RUN_PROJECT=1
RUN_IN_FOREGROUND=0
RUN_WITHOUT_SCREEN=1

function usage
{
    echo "
    USAGE: build_pd.sh [[-i input folder containing _main.pd file ] [-o output folder for new heavy project .c files (default ../projects/heavy/hvtemp)] [-b bbb path to copy to (default ~/BeagleRT)] | [-h]]
    "    
    echo "example: build_pd.sh -i ../projects/heavy/pd/hello-world -o ../projects/heavy/hello-world"
}

while [ "$1" != "" ]; do
    case $1 in
        -b | --bbb )            shift
                                BBB_PATH=$1
                                ;;
        -i | --input )          shift
                                pdpath=$1
                                ;;
        -o | --output )         shift
                                projectpath=$1
                                ;;
        -v | --verbose )        shift
                                verbose=1
                                ;;
        -r | --render )         shift
                                render=1
                                ;;
        -h | --help )           usage
                                exit
                                ;;
        * )                     usage
                                exit 1
    esac
    shift
done

# remove old static files to avoid obsolete errors
rm "$projectpath"/Hv* "$projectpath"/Message* "$projectpath"/Control* "$projectpath"/Signal* &>/dev/null

/usr/bin/python hvresources/uploader.py "$pdpath"/ -n bbb -g c -o "$projectpath"/;
if [ $? -ne 0 ]; then
    /usr/local/bin/python hvresources/uploader.py "$pdpath"/ -n bbb -g c -o "$projectpath"/;
    if [ $? -ne 0 ]; then
        #echo "ERROR: an error occurred while executing the uploader.py script"
        echo "error"
        exit 1
    fi;
fi;
echo "";
#echo "*|*|* Successfully uploaded and converted pd patch into super-fast optimized C code. Brought to you by Heavy! *|*|*";
echo "";

# check how to copy/sync render.cpp file...
if [ $render -eq 0 ]; then
    cp "hvresources/render.cpp" $projectpath/;
fi;

cp "hvresources/HvUtils.h" $projectpath/;

echo "updating files on board..."

rsync -c -r --exclude 'HvContext*' "$projectpath"/ "$BBB_ADDRESS":"$BBB_PATH"/source;

scp "$projectpath"/HvContext* "$BBB_ADDRESS":"$BBB_PATH"/source;

if [ $? -ne 0 ]; then
    echo "";
    echo ":( :( :( ERROR: while synchronizing files with the BBB. Is the board connected and the correct SD card inserted? :( :( :(";
    echo "";
    exit 1;
fi;

# remove old executable and heavy context .o/.d files
ssh $BBB_ADDRESS "rm $BBB_PATH/BeagleRT $BBB_PATH/build/source/HvContext_bbb.d $BBB_PATH/build/source/HvContext_bbb.o $BBB_PATH/build/source/render.o $BBB_PATH/build/source/render.d";

# Make new BeagleRT executable and run
if [ $RUN_PROJECT -eq 0 ]
then
    echo "Building project..."
    ssh $BBB_ADDRESS "make all -C $BBB_PATH"
else
    echo "Building and running project..."
    
    if [ $RUN_WITHOUT_SCREEN -ne 0 ]
    then
        ssh -t $BBB_ADDRESS "make all -C $BBB_PATH && $BBB_PATH/BeagleRT $COMMAND_ARGS" 
    elif [ $RUN_IN_FOREGROUND -eq 0 ]
    then
        ssh $BBB_ADDRESS "make all -C $BBB_PATH && screen -S BeagleRT -d -m $BBB_PATH/BeagleRT $COMMAND_ARGS"
    else
        ssh -t $BBB_ADDRESS "make all -C $BBB_PATH && screen -S BeagleRT $BBB_PATH/BeagleRT $COMMAND_ARGS"
    fi
fi








#ssh -t root@192.168.7.2 "kill -s 2 \`pidof heavy_template\` 2>/dev/null; sleep 0.5; rm -f ~/$filename_bbb/Release/source/heavy/HvContext_bbb.? ~/$filename_bbb/Release/heavy_template && make all -C ~/$filename_bbb/Release" &>/dev/null
