//scope.cpp
#include <BeagleRT.h> 
#include <rtdk.h>
#include <cmath>
#include <UdpClient.h>

#define NETWORK_AUDIO_BUFFER_SIZE 400
struct networkAudio{
	int timestamp;
	int currentBuffer;
	int index;
	float buffers[2][NETWORK_AUDIO_BUFFER_SIZE]; 
	int doneOnTime;
	bool toBeSent;
	UdpClient udpClient;
};

#define NUM_SCOPE_CHANNELS 6

static void SendScopeData();

class Scope {
    int sampleCount; 
    float sampleRate;
    AuxiliaryTask scopeTask;
  public:
    int numChannels;
    networkAudio channel[NUM_SCOPE_CHANNELS];
    Scope(){
        numChannels = NUM_SCOPE_CHANNELS;
        sampleCount = 0;
        
        for(int n=0; n<numChannels; n++){
            channel[n].doneOnTime=1;
            channel[n].index=2; //leave space for the heading message (channel, timestamp)
            channel[n].timestamp=0;
            channel[n].currentBuffer=0;
            channel[n].toBeSent=false;
#ifdef BUILD_FOR_UDPRECEIVE_PLUGIN
            channel[n].udpClient.setPort(9999+n);
            channel[n].udpClient.setServer("192.168.7.1");
#else
            channel[n].udpClient.setPort(9999);
            channel[n].udpClient.setServer("127.0.0.1");
#endif /* BUILD_FOR_UDPRECEIVE_PLUGIN */
    	}
    }
    void setup(float _sampleRate);
    void log(float channel1=0.0, float channel2=0.0, float channel3=0.0, float channel4=0.0, float channel5=0.0, float channel6=0.0){
        
        for(int j=0; j<numChannels; j++){
			if(channel[j].index==(NETWORK_AUDIO_BUFFER_SIZE)){ // when the buffer is ready ...
              channel[j].buffers[channel[j].currentBuffer][0] = (float)j;
              channel[j].buffers[channel[j].currentBuffer][1] = (float)channel[j].timestamp;
				channel[j].toBeSent=true;
				channel[j].index=2; //reset the counter
				if(channel[j].doneOnTime==0)
					rt_printf("Network buffer underrun :-{\n");
				channel[j].timestamp=sampleCount;
				channel[j].currentBuffer=!channel[j].currentBuffer; //switch buffer
				channel[j].doneOnTime=0;
				BeagleRT_scheduleAuxiliaryTask(scopeTask); //send the buffer
			}
		}
      
      	channel[0].buffers[channel[0].currentBuffer][channel[0].index++]=channel1;
      	channel[1].buffers[channel[1].currentBuffer][channel[1].index++]=channel2;
      	channel[2].buffers[channel[2].currentBuffer][channel[2].index++]=channel3;
      	channel[3].buffers[channel[3].currentBuffer][channel[3].index++]=channel4;
      	channel[4].buffers[channel[4].currentBuffer][channel[4].index++]=channel5;
      	channel[5].buffers[channel[5].currentBuffer][channel[5].index++]=channel6;

	sampleCount++;
    }
};

Scope* gOscilloscopeInstance;

void Scope::setup(float _sampleRate){
    sampleRate = _sampleRate;
    gOscilloscopeInstance = this;
    scopeTask = BeagleRT_createAuxiliaryTask(*SendScopeData, 98, "transmit-receive-audio");
}

//Scope scope; 

static void SendScopeData(){
    for(int n=0; n<gOscilloscopeInstance->numChannels; n++){
		if(gOscilloscopeInstance->channel[n].toBeSent){
			gOscilloscopeInstance->channel[n].toBeSent=false;
			gOscilloscopeInstance->channel[n].udpClient.send(
				gOscilloscopeInstance->channel[n].buffers[!gOscilloscopeInstance->channel[n].currentBuffer],
				NETWORK_AUDIO_BUFFER_SIZE*sizeof(float)
			);
			gOscilloscopeInstance->channel[n].doneOnTime=1;
		}
	}
}
