/*
 * Utilities.h
 *
 *  Created on: Oct 27, 2014
 *      Author: parallels
 */

#ifndef UTILITIES_H_
#define UTILITIES_H_

extern int gNumAudioChannels;	// How many audio channels are present
extern int gNumMatrixChannels;	// How many matrix channels are present

// Macros for accessing the matrix values: usable _only_ within render()

// Read an analog input from input pin p at frame f
#define analogRead(p, f) (matrixIn[(f)*gNumMatrixChannels + (p)])
// Write an analog output frame at output pin p, frame f, to value v
#define analogWriteFrame(p, f, v) (matrixOut[(f)*gNumMatrixChannels + (p)] = (v))
#define analogWrite(pin, frame, value) \
(({do {\
	for (int _privateI=(frame); _privateI<numMatrixFrames; _privateI++){ \
		analogWriteFrame(pin,_privateI,value); \
	}\
	} while (0);}),(void)0)\

#define setBit(word,bit) ((word)|(1<<(bit)))
#define clearBit(word,bit) ((word)&~(1<<(bit)))
#define getBit(word,bit) (((word)>>(bit))&1)
#define changeBit(word,bit,value) ((clearBit((word),(bit))) | ((value)<<(bit)))
//matrixGpio API:
#define setDigitalDirectionFrame(pin,frame,direction) matrixGpio[(frame)]=changeBit(matrixGpio[(frame)],(pin),(direction))
#define setDigitalDirection(pin,frame,direction) (for(int _privateI=(frame);_privateI<gNumGpioFrames;_privateI++) matrixGpio[_privateI]=changeBit(matrixGpio[(_privateI)],(pin),(direction))),void(0)
#define digitalWriteAll(frame,value) matrixGpio[(frame)]=0xffff0000*(!(!value));
//sets the bit in the high word, clears the bit in the low word (just in case the direction was not previously set)
#define digitalWriteFrame(pin, frame, value) matrixGpio[(frame)]=( changeBit(matrixGpio[(frame)], (pin+16), (value)) & (0xffffffff-(1<<(pin))) ) //could have been done with two subsequent assignments
#define digitalWrite(pin, frame, value) \
	(({do {\
		for (int _privateI=(frame); _privateI<gNumMatrixGpioFrames; _privateI++) \
			digitalWriteFrame(pin,_privateI,value); \
		} while (0);}),(void)0)\

#define digitalRead(pin, frame) ( getBit(matrixGpio[(frame)], pin+16) )

float map(float x, float in_min, float in_max, float out_min, float out_max);
float constrain(float x, float min_val, float max_val);

#endif /* UTILITIES_H_ */
