#!/bin/sh
#
# This script stops the Bela program running on the BeagleBone.

[ -z "$BBB_ADDRESS" ] && BBB_ADDRESS="root@192.168.7.2"
[ -z "$BBB_BELA_HOME" ] && BBB_BELA_HOME="~/Bela/"
[ -z "$BBB_SCREEN_NAME" ] && BBB_SCREEN_NAME="Bela"
[ -z "$RUN_PROJECT" ] && RUN_PROJECT=1
[ -z "$COMMAND_ARGS" ] && COMMAND_ARGS=
[ -z "$RUN_IN_FOREGROUND" ] && RUN_IN_FOREGROUND=1
[ -z "$RUN_WITHOUT_SCREEN" ] && RUN_WITHOUT_SCREEN=0
[ -z "$BBB_PROJECT_HOME" ] && BBB_PROJECT_HOME="${BBB_BELA_HOME}/projects/"
[ -z "$BBB_DEFAULT_PROJECT_NAME" ] && BBB_DEFAULT_PROJECT_NAME="scriptUploadedProject"
[ -z "$BBB_PROJECT_NAME" ] && BBB_PROJECT_NAME=$BBB_DEFAULT_PROJECT_NAME
# The first command should be sufficient to stop any Bela run with
# these scripts; the second will catch any leftovers run other ways

BELA_AUDIO_THREAD_NAME=beaglert-audio 
ssh $BBB_ADDRESS make --no-print-directory -C $BBB_BELA_HOME stop
