#ifndef RECEIVEAUDIOTHREAD_H_INCLUDED
#define RECEIVEAUDIOTHREAD_H_INCLUDED
#include <vector>
#include <iostream>
#include <UdpServer.h>
#include <BeagleRT.h>
#include <native/task.h>

class ReceiveAudioThread{
private:
    //  FILE *fd; //DEBUG
    //  FILE *fd2; //DEBUG
    UdpServer socket;
//JUCE    DatagramSocket socket;
    bool listening;
    bool bufferReady;
#ifdef JUCE
    bool threadRunning;
#else
    static bool threadRunning;
    static bool threadIsExiting;
#endif
    float *buffer;
    float *stackBuffer;
    int bufferLength;
    float readPointer;
    int writePointer;
    int lastValidPointer;
#ifdef JUCE
    int sleepTime;
#else
    static int sleepTime;
#endif
    int waitForSocketTime;
    int payloadLength; //size of the payload of each datagram
    int headerLength; //size of the header of each datagram
    int bytesToRead;
    int threadPriority;
    int channel;
    void dealloc();
    void wrapWritePointer();
    void pushPayload(int startIndex);
    void popPayload(int startIndex);
    int readUdpToBuffer();
#ifdef JUCE
#else
    static bool threadShouldExit();
	static bool staticConstructed;
    static void staticConstructor();
    static AuxiliaryTask receiveDataTask; //TODO: allow different AuxiliaryTasks for different priorities (e.g.: audio vs scope)
    static std::vector<ReceiveAudioThread *> objAddrs;
#endif
public:
    ReceiveAudioThread();
    ~ReceiveAudioThread();
    void init(int port, int aSamplesPerBlock, int channel);
    void setup();
    void bindToPort(int aPort);
    bool isListening();
    float* getCurrentBuffer(int length);
    /**
     * Copies the samples to a non-interleaved buffer.
     */
    int getSamplesSrc(float *destination, int length, float samplingRateRatio);
    /**
     * Copies the samples to an interleaved buffer.
     */
    int getSamplesSrc(float *destination, int length,
    		float samplingRateRatio, int numChannelsInDestination,
    		int channelToWriteTo);
    bool isBufferReady();
#ifdef JUCE // if we are in Juce, then we run a separate thread for each receiver
    		// (as each of them are typically receiving on a mono or stereo track)
    void run();
#else
    void static run(); //while in BeagleRT we have a single thread that receives for all the instances.
    //TODO: make run() private in BeagleRT
    static void startThread();
    static void stopThread();
    static int getNumInstances();
#endif // JUCE
};
#endif  // RECEIVEAUDIOTHREAD_H_INCLUDED
