    /*
 *
 * First assignment for ECS732 RTDSP, to implement a 2-way audio crossover
 * using the BeagleBone Black.
 *
 * Andrew McPherson and Victor Zappi
 * Queen Mary, University of London
 */

#include "../../include/render.h"
#include <cmath>
#include <rtdk.h>

/* TASK: declare any global variables you need here */

// initialise_render() is called once before the audio rendering starts.
// Use it to perform any initialisation and allocation which is dependent
// on the period size or sample rate.
//
// userData holds an opaque pointer to a data structure that was passed
// in from the call to initAudio().
//
// Return true on success; returning false halts the program.
int gNumDigitalFrames=0;
bool initialise_render(int numAnalogChannels, int numDigitalChannels, int numAudioChannels,
					   int numAnalogFramesPerPeriod,
					   int numAudioFramesPerPeriod,
					   float analogSampleRate, float audioSampleRate,
					   void *userData)
{
	gNumAnalogChannels=numAnalogChannels;
    gNumDigitalChannels=numDigitalChannels;
	return true;
}

// render() is called regularly at the highest priority by the audio engine.
// Input and output are given from the audio hardware and the other
// ADCs and DACs (if available). If only audio is available, numAnalogFrames
// will be 0.

long int gCountFrames=0;
void render(int numAnalogFrames, int numDigitalFrames, int numAudioFrames, float *audioIn, float *audioOut,
			float *analogIn, float *analogOut, uint32_t *digital)
/*
we assume that gNumAnalogChannels=8, numAnalogFrames==8 and  numDigitalFrames==numAudioFrames
 * */
{
	gNumDigitalFrames=numDigitalFrames;

	if((gCountFrames&31)==0){ //every 32 frames...
        //ANALOG channels
		analogWrite(0, 0, analogRead(0,0)); // read the input0 at frame0  and write it to output0 frame0. Using analogWrite will fill the rest of the buffer with the same value
                                            // The value at the last frame will persist through the successive buffers until is set again.
                                            // This effectively is a pass-through with downsampling by 32 times
        analogWrite(3, 0, 1.0);  // write 1.0 to channel3 from frame0 to the end of the buffer
        analogWrite(3, 4, 0.1);  // write 0.1  to channel3 from frame4 to the end of the buffer
        analogWriteFrame(3,6,0.2); //write 0.2 to channel3 only on frame 6
        //this buffer for channel 3 will look like this:  1 1 1 1 0.1 0.1 0.2 0.1 
        //the next buffers for channel 3 will be filled up with 0.1 ....
        //DIGITAL channels
        digitalWrite(P8_07,0,GPIO_HIGH); //sets all the frames  to HIGH for channel 0
        digitalWriteFrame(P8_07,4,GPIO_LOW); //only frame 4 will be LOW  for channel 0
        // in this buffer the frames of channel 0 will look like this: 1 1 1 1 0 1 1 1 ...... 1 
        // in the next buffer each frame of channel 0 will be initialized to 1 (the last value of this buffer)
        digitalWrite(P8_08,0,GPIO_HIGH);
        digitalWrite(P8_08,2,GPIO_LOW);
        digitalWrite(P8_08,4,GPIO_HIGH);
        digitalWrite(P8_08,5,GPIO_LOW);
        // in this buffer the frames of channel 1 will look like this: 1 1 0 0 1 0 0 0 .... 0
        // in the next buffer each frame of channel 1 will be initialized to 0 (the last value of this buffer)
	}
	for(int n=0; n<numAudioFrames; n++){
		for(int c=0; c<gNumAudioChannels; c++){
			audioOut[n*gNumAudioChannels + c]=audioIn[n*gNumAudioChannels + c];
		}
        //use digital channels 2-5 to create a 4 bit binary counter
        digital[n]=digital[n] & (~0b111100); // set to zero (GPIO_OUTPUT) the bits in the lower word
        digital[n]=digital[n] & (~0b111100<<16); //initialize to zero the bits in the higher word (output value)
        digital[n]=digital[n] | (n<<(16+2));  // set the bits in the higher word to the desired output value
	}

	for(int n=0; n<numAnalogFrames; n++){
    	analogWriteFrame(1,n,(gCountFrames&8191)/8192.0); // writes a single frame. channel 1 is a ramp that follows gCountFrames
    	analogWriteFrame(2,n,analogRead(2,n)); // writes a single frame. channel2 is just a passthrough
//		rt_printf("Analog out frame %d :",n);
//		for(int c=0; c<gNumAnalogChannels; c++)
//			rt_printf("%.1f ",analogOut[n*gNumAnalogChannels + c]);
//		rt_printf("\n");
		gCountFrames++;
	}
	return;

}
// cleanup_render() is called once at the end, after the audio has stopped.
// Release any resources that were allocated in initialise_render().

void cleanup_render()
{
	/* TASK:
	 * If you allocate any memory, be sure to release it here.
	 * You may or may not need anything in this function, depending
	 * on your implementation.
	 */
}
