// this example reads the analogue inputs 0 and 1
// and generates a sine wave with an amplitude and
// frequency determined by their values
// it then plots these on the oscilloscope

#include <Bela.h>
#include <cmath>
#include <Scope.h>

Scope scope;

float gInverseSampleRate;
float gPhase;

bool setup(BelaContext *context, void *userData)
{

    // setup the scope with 3 channels at the audio sample rate
	scope.setup(3, context->audioSampleRate);
	
	gInverseSampleRate = 1.0 / context->audioSampleRate;
	gPhase = 0.0;

	return true;
}

void render(BelaContext *context, void *userData)
{

	for(unsigned int n = 0; n < context->audioFrames; n++) {
	    
	    // read analogIn channels 0 and 1
	    float in1 = analogReadFrame(context, n, 0);
	    float in2 = analogReadFrame(context, n, 1);
	    
	    // map in1 to amplitude and in2 to frequency
	    float amplitude = in1 * 0.8f;
	    float frequency = map(in2, 0, 1, 100, 1000);
	    
	    // generate a sine wave with the amplitude and frequency 
	    float out = amplitude * sinf(gPhase);
	    gPhase += 2.0 * M_PI * frequency * gInverseSampleRate;
		if(gPhase > 2.0 * M_PI)
			gPhase -= 2.0 * M_PI;
	    
	    // log the sine wave and sensor values on the scope
	    scope.log(out, in1, in2);
	    
	    // pass the sine wave to the audio outputs
	    for(unsigned int channel = 0; channel < context->audioChannels; channel++)
			context->audioOut[n * context->audioChannels + channel] = out;

	}
}

void cleanup(BelaContext *context, void *userData)
{

}
