/*
 * main.cpp
 *
 *  Created on: Oct 24, 2014
 *      Author: parallels
 */

#include <iostream>
#include <cstdlib>
#include <libgen.h>
#include <signal.h>
#include "../../include/RTAudio.h"

using namespace std;

// Handle Ctrl-C by requesting that the audio rendering stop
void interrupt_handler(int var)
{
	gShouldStop = true;
}

// Print usage information
void usage(const char * processName)
{
	cerr << "Usage: " << processName << " [-h] [-v] [-p period] [-f input] [-a input]" << endl;
	cerr << "   -h:           Print this menu\n";
	cerr << "   -v:           Enable verbose messages\n";
	cerr << "   -p period:    Set the period (hardware buffer) size in sensor frames\n";
	cerr << "   -f frequency: Set frequency of LED fade (default: 1.0)\n";
}

int main(int argc, char *argv[])
{
	int periodSize = 8;			// Period size in sensor frames
	int verbose = 0;			// Verbose printing level
	float frequency = 1.0;		// Frequency of LED fades

	// Parse command-line arguments
	while (1) {
		int c;
		if ((c = getopt(argc, argv, "hp:vf:")) < 0)
				break;
		switch (c) {
		case 'h':
				usage(basename(argv[0]));
				exit(0);
		case 'p':
				periodSize = atoi(optarg);
				if(periodSize < 1)
					periodSize = 1;
				break;
		case 'v':
				verbose = 1;
				break;
		case 'f':
				frequency = atof(optarg);
				if(frequency < 0)
					frequency = 0;
				if(frequency > 11025.0)
					frequency = 11025.0;
				break;
		case '?':
		default:
				usage(basename(argv[0]));
				exit(1);
		}
	}


	// Set verbose logging information (optional by using value > 0; default is 0)
	setVerboseLevel(verbose);

	if(verbose) {
		cout << "Starting with period size " << periodSize << " and frequency " << frequency <<  endl;
	}

	// Initialise the PRU audio device
	if(initAudio(periodSize, 1, &frequency) != 0) {
		cout << "Error: unable to initialise audio" << endl;
		return -1;
	}

	// Start the audio device running
	if(startAudio()) {
		cout << "Error: unable to start real-time audio" << endl;
		return -1;
	}

	// Set up interrupt handler to catch Control-C
	signal(SIGINT, interrupt_handler);

	// Run until told to stop
	while(!gShouldStop) {
		usleep(100000);
	}

	// Stop the audio device
	stopAudio();

	if(verbose) {
		cout << "Cleaning up..." << endl;
	}

	// Clean up any resources allocated for audio
	cleanupAudio();

	// All done!
	return 0;
}
