/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

public class TestSuite
implements Test {
    private String fName;
    private Vector fTests = new Vector(10);
    static /* synthetic */ Class class$junit$framework$Test;

    public static Test createTest(Class clazz, String string) {
        Object t;
        Constructor constructor;
        try {
            constructor = TestSuite.getTestConstructor(clazz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return TestSuite.warning("Class " + clazz.getName() + " has no public constructor TestCase(String name) or TestCase()");
        }
        try {
            if (constructor.getParameterTypes().length == 0) {
                t = constructor.newInstance(new Object[0]);
                if (t instanceof TestCase) {
                    ((TestCase)t).setName(string);
                }
            } else {
                t = constructor.newInstance(string);
            }
        }
        catch (InstantiationException instantiationException) {
            return TestSuite.warning("Cannot instantiate test case: " + string + " (" + TestSuite.exceptionToString(instantiationException) + ")");
        }
        catch (InvocationTargetException invocationTargetException) {
            return TestSuite.warning("Exception in constructor: " + string + " (" + TestSuite.exceptionToString(invocationTargetException.getTargetException()) + ")");
        }
        catch (IllegalAccessException illegalAccessException) {
            return TestSuite.warning("Cannot access test case: " + string + " (" + TestSuite.exceptionToString(illegalAccessException) + ")");
        }
        return (Test)t;
    }

    public static Constructor getTestConstructor(Class clazz) throws NoSuchMethodException {
        Class[] classArray = new Class[]{String.class};
        try {
            return clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return clazz.getConstructor(new Class[0]);
        }
    }

    public static Test warning(final String string) {
        return new TestCase("warning"){

            protected void runTest() {
                1.fail(string);
            }
        };
    }

    private static String exceptionToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public TestSuite() {
    }

    public TestSuite(Class clazz) {
        this.fName = clazz.getName();
        try {
            TestSuite.getTestConstructor(clazz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.addTest(TestSuite.warning("Class " + clazz.getName() + " has no public constructor TestCase(String name) or TestCase()"));
            return;
        }
        if (!Modifier.isPublic(clazz.getModifiers())) {
            this.addTest(TestSuite.warning("Class " + clazz.getName() + " is not public"));
            return;
        }
        Class clazz2 = clazz;
        Vector vector = new Vector();
        while ((class$junit$framework$Test == null ? TestSuite.class$("junit.framework.Test") : class$junit$framework$Test).isAssignableFrom(clazz2)) {
            Method[] methodArray = clazz2.getDeclaredMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                this.addTestMethod(methodArray[i], vector, clazz);
            }
            clazz2 = clazz2.getSuperclass();
        }
        if (this.fTests.size() == 0) {
            this.addTest(TestSuite.warning("No tests found in " + clazz.getName()));
        }
    }

    public TestSuite(Class clazz, String string) {
        this(clazz);
        this.setName(string);
    }

    public TestSuite(String string) {
        this.setName(string);
    }

    public TestSuite(Class[] classArray) {
        for (int i = 0; i < classArray.length; ++i) {
            this.addTest(new TestSuite(classArray[i]));
        }
    }

    public TestSuite(Class[] classArray, String string) {
        this(classArray);
        this.setName(string);
    }

    public void addTest(Test test) {
        this.fTests.addElement(test);
    }

    public void addTestSuite(Class clazz) {
        this.addTest(new TestSuite(clazz));
    }

    public int countTestCases() {
        int n = 0;
        Enumeration enumeration = this.tests();
        while (enumeration.hasMoreElements()) {
            Test test = (Test)enumeration.nextElement();
            n += test.countTestCases();
        }
        return n;
    }

    public String getName() {
        return this.fName;
    }

    public void run(TestResult testResult) {
        Enumeration enumeration = this.tests();
        while (enumeration.hasMoreElements() && !testResult.shouldStop()) {
            Test test = (Test)enumeration.nextElement();
            this.runTest(test, testResult);
        }
    }

    public void runTest(Test test, TestResult testResult) {
        test.run(testResult);
    }

    public void setName(String string) {
        this.fName = string;
    }

    public Test testAt(int n) {
        return (Test)this.fTests.elementAt(n);
    }

    public int testCount() {
        return this.fTests.size();
    }

    public Enumeration tests() {
        return this.fTests.elements();
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return super.toString();
    }

    private void addTestMethod(Method method, Vector vector, Class clazz) {
        String string = method.getName();
        if (vector.contains(string)) {
            return;
        }
        if (!this.isPublicTestMethod(method)) {
            if (this.isTestMethod(method)) {
                this.addTest(TestSuite.warning("Test method isn't public: " + method.getName()));
            }
            return;
        }
        vector.addElement(string);
        this.addTest(TestSuite.createTest(clazz, string));
    }

    private boolean isPublicTestMethod(Method method) {
        return this.isTestMethod(method) && Modifier.isPublic(method.getModifiers());
    }

    private boolean isTestMethod(Method method) {
        String string = method.getName();
        Class<?>[] classArray = method.getParameterTypes();
        Class<?> clazz = method.getReturnType();
        return classArray.length == 0 && string.startsWith("test") && clazz.equals(Void.TYPE);
    }
}

