/*
 * Decompiled with CFR 0.152.
 */
package junit.swingui;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageProducer;
import java.net.URL;
import java.util.Vector;
import junit.awtui.AboutDialog;
import junit.awtui.Logo;
import junit.awtui.ProgressBar;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.runner.BaseTestRunner;

public class TestRunner
extends BaseTestRunner {
    protected Frame fFrame;
    protected Vector fExceptions;
    protected Vector fFailedTests;
    protected Thread fRunner;
    protected TestResult fTestResult;
    protected TextArea fTraceArea;
    protected TextField fSuiteField;
    protected Button fRun;
    protected ProgressBar fProgressIndicator;
    protected List fFailureList;
    protected Logo fLogo;
    protected Label fNumberOfErrors;
    protected Label fNumberOfFailures;
    protected Label fNumberOfRuns;
    protected Button fQuitButton;
    protected Button fRerunButton;
    protected TextField fStatusLine;
    protected Checkbox fUseLoadingRunner;
    protected static final Font PLAIN_FONT = new Font("dialog", 0, 12);
    private static final int GAP = 4;

    private void about() {
        AboutDialog aboutDialog = new AboutDialog(this.fFrame);
        aboutDialog.setModal(true);
        aboutDialog.setLocation(300, 300);
        aboutDialog.setVisible(true);
    }

    public void testStarted(String string) {
        this.showInfo("Running: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnded(String string) {
        this.setLabelValue(this.fNumberOfRuns, this.fTestResult.runCount());
        TestRunner testRunner = this;
        synchronized (testRunner) {
            this.fProgressIndicator.step(this.fTestResult.wasSuccessful());
        }
    }

    public void testFailed(int n, Test test, Throwable throwable) {
        switch (n) {
            case 1: {
                this.fNumberOfErrors.setText(Integer.toString(this.fTestResult.errorCount()));
                this.appendFailure("Error", test, throwable);
                break;
            }
            case 2: {
                this.fNumberOfFailures.setText(Integer.toString(this.fTestResult.failureCount()));
                this.appendFailure("Failure", test, throwable);
            }
        }
    }

    protected void addGrid(Panel panel, Component component, int n, int n2, int n3, int n4, double d, int n5) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.weightx = d;
        gridBagConstraints.fill = n4;
        if (n4 == 1 || n4 == 3) {
            gridBagConstraints.weighty = 1.0;
        }
        gridBagConstraints.insets = new Insets(n2 == 0 ? 4 : 0, n == 0 ? 4 : 0, 4, 4);
        panel.add(component, gridBagConstraints);
    }

    private void appendFailure(String string, Test test, Throwable throwable) {
        string = string + ": " + test;
        String string2 = throwable.getMessage();
        if (string2 != null) {
            string = string + ":" + TestRunner.truncate(string2);
        }
        this.fFailureList.add(string);
        this.fExceptions.addElement(throwable);
        this.fFailedTests.addElement(test);
        if (this.fFailureList.getItemCount() == 1) {
            this.fFailureList.select(0);
            this.failureSelected();
        }
    }

    protected Menu createJUnitMenu() {
        Menu menu = new Menu("JUnit");
        MenuItem menuItem = new MenuItem("About...");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestRunner.this.about();
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new MenuItem("Exit");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        menu.add(menuItem);
        return menu;
    }

    protected void createMenus(MenuBar menuBar) {
        menuBar.add(this.createJUnitMenu());
    }

    protected TestResult createTestResult() {
        return new TestResult();
    }

    protected Frame createUI(String string) {
        Frame frame = new Frame("JUnit");
        Image image = this.loadFrameIcon();
        if (image != null) {
            frame.setIconImage(image);
        }
        frame.setLayout(new BorderLayout(0, 0));
        frame.setBackground(SystemColor.control);
        final Frame frame2 = frame;
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                frame2.dispose();
                System.exit(0);
            }
        });
        MenuBar menuBar = new MenuBar();
        this.createMenus(menuBar);
        frame.setMenuBar(menuBar);
        Label label = new Label("Test class name:");
        this.fSuiteField = new TextField(string != null ? string : "");
        this.fSuiteField.selectAll();
        this.fSuiteField.requestFocus();
        this.fSuiteField.setFont(PLAIN_FONT);
        this.fSuiteField.setColumns(40);
        this.fSuiteField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestRunner.this.runSuite();
            }
        });
        this.fSuiteField.addTextListener(new TextListener(){

            public void textValueChanged(TextEvent textEvent) {
                TestRunner.this.fRun.setEnabled(TestRunner.this.fSuiteField.getText().length() > 0);
                TestRunner.this.fStatusLine.setText("");
            }
        });
        this.fRun = new Button("Run");
        this.fRun.setEnabled(false);
        this.fRun.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestRunner.this.runSuite();
            }
        });
        boolean bl = this.useReloadingTestSuiteLoader();
        this.fUseLoadingRunner = new Checkbox("Reload classes every run", bl);
        if (TestRunner.inVAJava()) {
            this.fUseLoadingRunner.setVisible(false);
        }
        this.fProgressIndicator = new ProgressBar();
        this.fNumberOfErrors = new Label("0000", 2);
        this.fNumberOfErrors.setText("0");
        this.fNumberOfErrors.setFont(PLAIN_FONT);
        this.fNumberOfFailures = new Label("0000", 2);
        this.fNumberOfFailures.setText("0");
        this.fNumberOfFailures.setFont(PLAIN_FONT);
        this.fNumberOfRuns = new Label("0000", 2);
        this.fNumberOfRuns.setText("0");
        this.fNumberOfRuns.setFont(PLAIN_FONT);
        Panel panel = this.createCounterPanel();
        Label label2 = new Label("Errors and Failures:");
        this.fFailureList = new List(5);
        this.fFailureList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                TestRunner.this.failureSelected();
            }
        });
        this.fRerunButton = new Button("Run");
        this.fRerunButton.setEnabled(false);
        this.fRerunButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestRunner.this.rerun();
            }
        });
        Panel panel2 = new Panel(new GridLayout(0, 1, 0, 2));
        panel2.add(this.fRerunButton);
        this.fTraceArea = new TextArea();
        this.fTraceArea.setRows(5);
        this.fTraceArea.setColumns(60);
        this.fStatusLine = new TextField();
        this.fStatusLine.setFont(PLAIN_FONT);
        this.fStatusLine.setEditable(false);
        this.fStatusLine.setForeground(Color.red);
        this.fQuitButton = new Button("Exit");
        this.fQuitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.fLogo = new Logo();
        Panel panel3 = new Panel(new GridBagLayout());
        this.addGrid(panel3, label, 0, 0, 2, 2, 1.0, 17);
        this.addGrid(panel3, this.fSuiteField, 0, 1, 2, 2, 1.0, 17);
        this.addGrid(panel3, this.fRun, 2, 1, 1, 2, 0.0, 10);
        this.addGrid(panel3, this.fUseLoadingRunner, 0, 2, 2, 0, 1.0, 17);
        this.addGrid(panel3, this.fProgressIndicator, 0, 3, 2, 2, 1.0, 17);
        this.addGrid(panel3, this.fLogo, 2, 3, 1, 0, 0.0, 11);
        this.addGrid(panel3, panel, 0, 4, 2, 0, 0.0, 17);
        this.addGrid(panel3, label2, 0, 5, 2, 2, 1.0, 17);
        this.addGrid(panel3, this.fFailureList, 0, 6, 2, 1, 1.0, 17);
        this.addGrid(panel3, panel2, 2, 6, 1, 2, 0.0, 10);
        this.addGrid(panel3, this.fTraceArea, 0, 7, 2, 1, 1.0, 17);
        this.addGrid(panel3, this.fStatusLine, 0, 8, 2, 2, 1.0, 10);
        this.addGrid(panel3, this.fQuitButton, 2, 8, 1, 2, 0.0, 10);
        frame.add((Component)panel3, "Center");
        frame.pack();
        return frame;
    }

    protected Panel createCounterPanel() {
        Panel panel = new Panel(new GridBagLayout());
        this.addToCounterPanel(panel, new Label("Runs:"), 0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0));
        this.addToCounterPanel(panel, this.fNumberOfRuns, 1, 0, 1, 1, 0.33, 0.0, 10, 2, new Insets(0, 8, 0, 40));
        this.addToCounterPanel(panel, new Label("Errors:"), 2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0));
        this.addToCounterPanel(panel, this.fNumberOfErrors, 3, 0, 1, 1, 0.33, 0.0, 10, 2, new Insets(0, 8, 0, 40));
        this.addToCounterPanel(panel, new Label("Failures:"), 4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0));
        this.addToCounterPanel(panel, this.fNumberOfFailures, 5, 0, 1, 1, 0.33, 0.0, 10, 2, new Insets(0, 8, 0, 0));
        return panel;
    }

    private void addToCounterPanel(Panel panel, Component component, int n, int n2, int n3, int n4, double d, double d2, int n5, int n6, Insets insets) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.fill = n6;
        gridBagConstraints.insets = insets;
        panel.add(component, gridBagConstraints);
    }

    public void failureSelected() {
        this.fRerunButton.setEnabled(this.isErrorSelected());
        this.showErrorTrace();
    }

    private boolean isErrorSelected() {
        return this.fFailureList.getSelectedIndex() != -1;
    }

    private Image loadFrameIcon() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            URL uRL = BaseTestRunner.class.getResource("smalllogo.gif");
            return toolkit.createImage((ImageProducer)uRL.getContent());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Thread getRunner() {
        return this.fRunner;
    }

    public static void main(String[] stringArray) {
        new TestRunner().start(stringArray);
    }

    public static void run(Class clazz) {
        String[] stringArray = new String[]{clazz.getName()};
        TestRunner.main(stringArray);
    }

    public void rerun() {
        int n = this.fFailureList.getSelectedIndex();
        if (n == -1) {
            return;
        }
        Test test = (Test)this.fFailedTests.elementAt(n);
        this.rerunTest(test);
    }

    private void rerunTest(Test test) {
        Object object;
        if (!(test instanceof TestCase)) {
            this.showInfo("Could not reload " + test.toString());
            return;
        }
        Test test2 = null;
        TestCase testCase = (TestCase)test;
        try {
            object = this.getLoader().reload(test.getClass());
            test2 = TestSuite.createTest((Class)object, testCase.getName());
        }
        catch (Exception exception) {
            this.showInfo("Could not reload " + test.toString());
            return;
        }
        object = new TestResult();
        test2.run((TestResult)object);
        String string = test2.toString();
        if (((TestResult)object).wasSuccessful()) {
            this.showInfo(string + " was successful");
        } else if (((TestResult)object).errorCount() == 1) {
            this.showStatus(string + " had an error");
        } else {
            this.showStatus(string + " had a failure");
        }
    }

    protected void reset() {
        this.setLabelValue(this.fNumberOfErrors, 0);
        this.setLabelValue(this.fNumberOfFailures, 0);
        this.setLabelValue(this.fNumberOfRuns, 0);
        this.fProgressIndicator.reset();
        this.fRerunButton.setEnabled(false);
        this.fFailureList.removeAll();
        this.fExceptions = new Vector(10);
        this.fFailedTests = new Vector(10);
        this.fTraceArea.setText("");
    }

    protected void runFailed(String string) {
        this.showStatus(string);
        this.fRun.setLabel("Run");
        this.fRunner = null;
    }

    public synchronized void runSuite() {
        if (this.fRunner != null && this.fTestResult != null) {
            this.fTestResult.stop();
        } else {
            this.setLoading(this.shouldReload());
            this.fRun.setLabel("Stop");
            this.showInfo("Initializing...");
            this.reset();
            this.showInfo("Load Test Case...");
            final Test test = this.getTest(this.fSuiteField.getText());
            if (test != null) {
                this.fRunner = new Thread(){

                    public void run() {
                        TestRunner.this.fTestResult = TestRunner.this.createTestResult();
                        TestRunner.this.fTestResult.addListener(TestRunner.this);
                        TestRunner.this.fProgressIndicator.start(test.countTestCases());
                        TestRunner.this.showInfo("Running...");
                        long l = System.currentTimeMillis();
                        test.run(TestRunner.this.fTestResult);
                        if (TestRunner.this.fTestResult.shouldStop()) {
                            TestRunner.this.showStatus("Stopped");
                        } else {
                            long l2 = System.currentTimeMillis();
                            long l3 = l2 - l;
                            TestRunner.this.showInfo("Finished: " + TestRunner.this.elapsedTimeAsString(l3) + " seconds");
                        }
                        TestRunner.this.fTestResult = null;
                        TestRunner.this.fRun.setLabel("Run");
                        TestRunner.this.fRunner = null;
                        System.gc();
                    }
                };
                this.fRunner.start();
            }
        }
    }

    private boolean shouldReload() {
        return !TestRunner.inVAJava() && this.fUseLoadingRunner.getState();
    }

    private void setLabelValue(Label label, int n) {
        label.setText(Integer.toString(n));
        label.invalidate();
        label.getParent().validate();
    }

    public void setSuiteName(String string) {
        this.fSuiteField.setText(string);
    }

    private void showErrorTrace() {
        int n = this.fFailureList.getSelectedIndex();
        if (n == -1) {
            return;
        }
        Throwable throwable = (Throwable)this.fExceptions.elementAt(n);
        this.fTraceArea.setText(TestRunner.getFilteredTrace(throwable));
    }

    private void showInfo(String string) {
        this.fStatusLine.setFont(PLAIN_FONT);
        this.fStatusLine.setForeground(Color.black);
        this.fStatusLine.setText(string);
    }

    protected void clearStatus() {
        this.showStatus("");
    }

    private void showStatus(String string) {
        this.fStatusLine.setFont(PLAIN_FONT);
        this.fStatusLine.setForeground(Color.red);
        this.fStatusLine.setText(string);
    }

    public void start(String[] stringArray) {
        String string = this.processArguments(stringArray);
        this.fFrame = this.createUI(string);
        this.fFrame.setLocation(200, 200);
        this.fFrame.setVisible(true);
        if (string != null) {
            this.setSuiteName(string);
            this.runSuite();
        }
    }
}

