/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.AccessLevel;
import lombok.Data;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.handlers.TransformationsUtil;
import lombok.eclipse.Eclipse;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseHandlerUtil;
import lombok.eclipse.handlers.HandleEqualsAndHashCode;
import lombok.eclipse.handlers.HandleGetter;
import lombok.eclipse.handlers.HandleSetter;
import lombok.eclipse.handlers.HandleToString;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandleData
implements EclipseAnnotationHandler<Data> {
    @Override
    public boolean handle(AnnotationValues<Data> annotation, Annotation ast, EclipseNode annotationNode) {
        boolean notAClass;
        Data ann = annotation.getInstance();
        EclipseNode typeNode = (EclipseNode)annotationNode.up();
        TypeDeclaration typeDecl = null;
        if (typeNode.get() instanceof TypeDeclaration) {
            typeDecl = (TypeDeclaration)typeNode.get();
        }
        int modifiers = typeDecl == null ? 0 : typeDecl.modifiers;
        boolean bl = notAClass = (modifiers & 0x6200) != 0;
        if (typeDecl == null || notAClass) {
            annotationNode.addError("@Data is only supported on a class.");
            return false;
        }
        ArrayList<EclipseNode> nodesForConstructor = new ArrayList<EclipseNode>();
        LinkedHashMap<EclipseNode, Boolean> gettersAndSetters = new LinkedHashMap<EclipseNode, Boolean>();
        for (EclipseNode eclipseNode : typeNode.down()) {
            boolean isNonNull;
            if (eclipseNode.getKind() != AST.Kind.FIELD) continue;
            FieldDeclaration fieldDecl = (FieldDeclaration)eclipseNode.get();
            if (fieldDecl.name.length > 0 && fieldDecl.name[0] == '$' || (fieldDecl.modifiers & 8) != 0) continue;
            boolean isFinal = (fieldDecl.modifiers & 0x10) != 0;
            boolean bl2 = isNonNull = EclipseHandlerUtil.findAnnotations(fieldDecl, TransformationsUtil.NON_NULL_PATTERN).length != 0;
            if ((isFinal || isNonNull) && fieldDecl.initialization == null) {
                nodesForConstructor.add(eclipseNode);
            }
            gettersAndSetters.put(eclipseNode, !isFinal);
        }
        if (EclipseHandlerUtil.constructorExists(typeNode) == EclipseHandlerUtil.MemberExistsResult.NOT_EXISTS) {
            ConstructorDeclaration constructor = this.createConstructor(ann.staticConstructor().length() == 0, typeNode, nodesForConstructor, (ASTNode)ast);
            EclipseHandlerUtil.injectMethod(typeNode, (AbstractMethodDeclaration)constructor);
        }
        if (ann.staticConstructor().length() > 0 && EclipseHandlerUtil.methodExists("of", typeNode, false) == EclipseHandlerUtil.MemberExistsResult.NOT_EXISTS) {
            MethodDeclaration staticConstructor = this.createStaticConstructor(ann.staticConstructor(), typeNode, nodesForConstructor, (ASTNode)ast);
            EclipseHandlerUtil.injectMethod(typeNode, (AbstractMethodDeclaration)staticConstructor);
        }
        for (Map.Entry entry : gettersAndSetters.entrySet()) {
            new HandleGetter().generateGetterForField((EclipseNode)entry.getKey(), (ASTNode)annotationNode.get());
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            new HandleSetter().generateSetterForField((EclipseNode)entry.getKey(), (ASTNode)annotationNode.get());
        }
        new HandleEqualsAndHashCode().generateEqualsAndHashCodeForType(typeNode, annotationNode);
        new HandleToString().generateToStringForType(typeNode, annotationNode);
        return false;
    }

    private ConstructorDeclaration createConstructor(boolean isPublic, EclipseNode type, Collection<EclipseNode> fields, ASTNode source) {
        long p = (long)source.sourceStart << 32 | (long)source.sourceEnd;
        ConstructorDeclaration constructor = new ConstructorDeclaration(((CompilationUnitDeclaration)((EclipseNode)type.top()).get()).compilationResult);
        Eclipse.setGeneratedBy((ASTNode)constructor, source);
        constructor.modifiers = EclipseHandlerUtil.toEclipseModifier(isPublic ? AccessLevel.PUBLIC : AccessLevel.PRIVATE);
        constructor.annotations = null;
        constructor.selector = ((TypeDeclaration)type.get()).name;
        constructor.constructorCall = new ExplicitConstructorCall(1);
        Eclipse.setGeneratedBy((ASTNode)constructor.constructorCall, source);
        constructor.thrownExceptions = null;
        constructor.typeParameters = null;
        constructor.bits |= 0x800000;
        constructor.declarationSourceStart = constructor.sourceStart = source.sourceStart;
        constructor.bodyStart = constructor.sourceStart;
        constructor.declarationSourceEnd = constructor.sourceEnd = source.sourceEnd;
        constructor.bodyEnd = constructor.sourceEnd;
        constructor.arguments = null;
        ArrayList<Argument> args = new ArrayList<Argument>();
        ArrayList<Assignment> assigns = new ArrayList<Assignment>();
        ArrayList<Object> nullChecks = new ArrayList<Object>();
        for (EclipseNode fieldNode : fields) {
            Annotation[] copiedAnnotations;
            Statement nullCheck;
            FieldDeclaration field = (FieldDeclaration)fieldNode.get();
            FieldReference thisX = new FieldReference(("this." + new String(field.name)).toCharArray(), p);
            Eclipse.setGeneratedBy((ASTNode)thisX, source);
            thisX.receiver = new ThisReference((int)(p >> 32), (int)p);
            Eclipse.setGeneratedBy((ASTNode)thisX.receiver, source);
            thisX.token = field.name;
            SingleNameReference assignmentNameRef = new SingleNameReference(field.name, p);
            Eclipse.setGeneratedBy((ASTNode)assignmentNameRef, source);
            Assignment assignment = new Assignment((Expression)thisX, (Expression)assignmentNameRef, (int)p);
            Eclipse.setGeneratedBy((ASTNode)assignment, source);
            assigns.add(assignment);
            long fieldPos = (long)field.sourceStart << 32 | (long)field.sourceEnd;
            Argument argument = new Argument(field.name, fieldPos, Eclipse.copyType(field.type, source), 16);
            Eclipse.setGeneratedBy((ASTNode)argument, source);
            Annotation[] nonNulls = EclipseHandlerUtil.findAnnotations(field, TransformationsUtil.NON_NULL_PATTERN);
            Annotation[] nullables = EclipseHandlerUtil.findAnnotations(field, TransformationsUtil.NULLABLE_PATTERN);
            if (nonNulls.length != 0 && (nullCheck = EclipseHandlerUtil.generateNullCheck((AbstractVariableDeclaration)field, source)) != null) {
                nullChecks.add(nullCheck);
            }
            if ((copiedAnnotations = Eclipse.copyAnnotations(nonNulls, nullables, source)).length != 0) {
                argument.annotations = copiedAnnotations;
            }
            args.add(argument);
        }
        nullChecks.addAll(assigns);
        constructor.statements = nullChecks.isEmpty() ? null : nullChecks.toArray(new Statement[nullChecks.size()]);
        constructor.arguments = args.isEmpty() ? null : args.toArray(new Argument[args.size()]);
        return constructor;
    }

    private MethodDeclaration createStaticConstructor(String name, EclipseNode type, Collection<EclipseNode> fields, ASTNode source) {
        int pS = source.sourceStart;
        int pE = source.sourceEnd;
        long p = (long)pS << 32 | (long)pE;
        MethodDeclaration constructor = new MethodDeclaration(((CompilationUnitDeclaration)((EclipseNode)type.top()).get()).compilationResult);
        Eclipse.setGeneratedBy((ASTNode)constructor, source);
        constructor.modifiers = EclipseHandlerUtil.toEclipseModifier(AccessLevel.PUBLIC) | 8;
        TypeDeclaration typeDecl = (TypeDeclaration)type.get();
        if (typeDecl.typeParameters != null && typeDecl.typeParameters.length > 0) {
            TypeReference[] refs = new TypeReference[typeDecl.typeParameters.length];
            int idx = 0;
            for (TypeParameter param : typeDecl.typeParameters) {
                SingleTypeReference typeRef = new SingleTypeReference(param.name, (long)param.sourceStart << 32 | (long)param.sourceEnd);
                Eclipse.setGeneratedBy((ASTNode)typeRef, source);
                refs[idx++] = typeRef;
            }
            constructor.returnType = new ParameterizedSingleTypeReference(typeDecl.name, refs, 0, p);
        } else {
            constructor.returnType = new SingleTypeReference(((TypeDeclaration)type.get()).name, p);
        }
        Eclipse.setGeneratedBy((ASTNode)constructor.returnType, source);
        constructor.annotations = null;
        constructor.selector = name.toCharArray();
        constructor.thrownExceptions = null;
        constructor.typeParameters = Eclipse.copyTypeParams(((TypeDeclaration)type.get()).typeParameters, source);
        constructor.bits |= 0x800000;
        constructor.declarationSourceStart = constructor.sourceStart = source.sourceStart;
        constructor.bodyStart = constructor.sourceStart;
        constructor.declarationSourceEnd = constructor.sourceEnd = source.sourceEnd;
        constructor.bodyEnd = constructor.sourceEnd;
        ArrayList<Argument> args = new ArrayList<Argument>();
        ArrayList<SingleNameReference> assigns = new ArrayList<SingleNameReference>();
        AllocationExpression statement = new AllocationExpression();
        statement.sourceStart = pS;
        statement.sourceEnd = pE;
        Eclipse.setGeneratedBy((ASTNode)statement, source);
        statement.type = Eclipse.copyType(constructor.returnType, source);
        for (EclipseNode fieldNode : fields) {
            FieldDeclaration field = (FieldDeclaration)fieldNode.get();
            long fieldPos = (long)field.sourceStart << 32 | (long)field.sourceEnd;
            SingleNameReference nameRef = new SingleNameReference(field.name, fieldPos);
            Eclipse.setGeneratedBy((ASTNode)nameRef, source);
            assigns.add(nameRef);
            Argument argument = new Argument(field.name, fieldPos, Eclipse.copyType(field.type, source), 0);
            Eclipse.setGeneratedBy((ASTNode)argument, source);
            Annotation[] copiedAnnotations = Eclipse.copyAnnotations(EclipseHandlerUtil.findAnnotations(field, TransformationsUtil.NON_NULL_PATTERN), EclipseHandlerUtil.findAnnotations(field, TransformationsUtil.NULLABLE_PATTERN), source);
            if (copiedAnnotations.length != 0) {
                argument.annotations = copiedAnnotations;
            }
            args.add(new Argument(field.name, fieldPos, Eclipse.copyType(field.type, source), 16));
        }
        statement.arguments = assigns.isEmpty() ? null : assigns.toArray(new Expression[assigns.size()]);
        constructor.arguments = args.isEmpty() ? null : args.toArray(new Argument[args.size()]);
        constructor.statements = new Statement[]{new ReturnStatement((Expression)statement, (int)(p >> 32), (int)p)};
        Eclipse.setGeneratedBy((ASTNode)constructor.statements[0], source);
        return constructor;
    }
}

