/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse;

import java.lang.reflect.Field;
import lombok.eclipse.Eclipse;
import lombok.eclipse.EclipseAST;
import lombok.eclipse.EclipseASTAdapter;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.HandlerLibrary;
import lombok.patcher.Symbols;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.parser.Parser;

public class TransformEclipseAST {
    private final EclipseAST ast;
    private static final Field astCacheField;
    private static final HandlerLibrary handlers;
    private static boolean disableLombok;

    public static void transform_swapped(CompilationUnitDeclaration ast, Parser parser) {
        TransformEclipseAST.transform(parser, ast);
    }

    public static void transform(Parser parser, CompilationUnitDeclaration ast) {
        if (disableLombok) {
            return;
        }
        if (Symbols.hasSymbol("lombok.disable")) {
            return;
        }
        try {
            EclipseAST existing = TransformEclipseAST.getCache(ast);
            if (existing == null) {
                existing = new EclipseAST(ast);
                TransformEclipseAST.setCache(ast, existing);
            } else {
                existing.reparse();
            }
            new TransformEclipseAST(existing).go();
        }
        catch (Throwable t) {
            try {
                String message = "Lombok can't parse this source: " + t.toString();
                EclipseAST.addProblemToCompilationResult(ast, false, message, 0, 0);
                t.printStackTrace();
            }
            catch (Throwable t2) {
                try {
                    Eclipse.error(ast, "Can't create an error in the problems dialog while adding: " + t.toString(), t2);
                }
                catch (Throwable t3) {
                    disableLombok = true;
                }
            }
        }
    }

    private static EclipseAST getCache(CompilationUnitDeclaration ast) {
        if (astCacheField == null) {
            return null;
        }
        try {
            return (EclipseAST)astCacheField.get(ast);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void setCache(CompilationUnitDeclaration ast, EclipseAST cache) {
        if (astCacheField != null) {
            try {
                astCacheField.set(ast, cache);
            }
            catch (Exception ignore) {
                ignore.printStackTrace();
            }
        }
    }

    public TransformEclipseAST(EclipseAST ast) {
        this.ast = ast;
    }

    public void go() {
        handlers.skipPrintAST();
        this.ast.traverse(new AnnotationVisitor());
        handlers.callASTVisitors(this.ast);
        handlers.skipAllButPrintAST();
        this.ast.traverse(new AnnotationVisitor());
    }

    static {
        disableLombok = false;
        Field f = null;
        HandlerLibrary l = null;
        try {
            l = HandlerLibrary.load();
            f = CompilationUnitDeclaration.class.getDeclaredField("$lombokAST");
        }
        catch (Throwable t) {
            try {
                Eclipse.error(null, "Problem initializing lombok", t);
            }
            catch (Throwable t2) {
                System.err.println("Problem initializing lombok");
                t.printStackTrace();
            }
            disableLombok = true;
        }
        astCacheField = f;
        handlers = l;
    }

    private static class AnnotationVisitor
    extends EclipseASTAdapter {
        private AnnotationVisitor() {
        }

        public void visitAnnotationOnField(FieldDeclaration field, EclipseNode annotationNode, Annotation annotation) {
            if (annotationNode.isHandled()) {
                return;
            }
            CompilationUnitDeclaration top = (CompilationUnitDeclaration)((EclipseNode)annotationNode.top()).get();
            boolean handled = handlers.handle(top, annotationNode, annotation);
            if (handled) {
                annotationNode.setHandled();
            }
        }

        public void visitAnnotationOnMethodArgument(Argument arg, AbstractMethodDeclaration method, EclipseNode annotationNode, Annotation annotation) {
            if (annotationNode.isHandled()) {
                return;
            }
            CompilationUnitDeclaration top = (CompilationUnitDeclaration)((EclipseNode)annotationNode.top()).get();
            boolean handled = handlers.handle(top, annotationNode, annotation);
            if (handled) {
                annotationNode.setHandled();
            }
        }

        public void visitAnnotationOnLocal(LocalDeclaration local, EclipseNode annotationNode, Annotation annotation) {
            if (annotationNode.isHandled()) {
                return;
            }
            CompilationUnitDeclaration top = (CompilationUnitDeclaration)((EclipseNode)annotationNode.top()).get();
            boolean handled = handlers.handle(top, annotationNode, annotation);
            if (handled) {
                annotationNode.setHandled();
            }
        }

        public void visitAnnotationOnMethod(AbstractMethodDeclaration method, EclipseNode annotationNode, Annotation annotation) {
            if (annotationNode.isHandled()) {
                return;
            }
            CompilationUnitDeclaration top = (CompilationUnitDeclaration)((EclipseNode)annotationNode.top()).get();
            boolean handled = handlers.handle(top, annotationNode, annotation);
            if (handled) {
                annotationNode.setHandled();
            }
        }

        public void visitAnnotationOnType(TypeDeclaration type, EclipseNode annotationNode, Annotation annotation) {
            if (annotationNode.isHandled()) {
                return;
            }
            CompilationUnitDeclaration top = (CompilationUnitDeclaration)((EclipseNode)annotationNode.top()).get();
            boolean handled = handlers.handle(top, annotationNode, annotation);
            if (handled) {
                annotationNode.setHandled();
            }
        }
    }
}

