/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac;

import com.sun.tools.javac.tree.JCTree;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;
import lombok.core.AnnotationValues;
import lombok.core.PrintAST;
import lombok.core.SpiLoadUtil;
import lombok.core.TypeLibrary;
import lombok.core.TypeResolver;
import lombok.javac.Javac;
import lombok.javac.JavacAST;
import lombok.javac.JavacASTVisitor;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;

public class HandlerLibrary {
    private final TypeLibrary typeLibrary = new TypeLibrary();
    private final Map<String, AnnotationHandlerContainer<?>> annotationHandlers = new HashMap();
    private final Collection<JavacASTVisitor> visitorHandlers = new ArrayList<JavacASTVisitor>();
    private final Messager messager;
    private boolean skipPrintAST = true;

    public HandlerLibrary(Messager messager) {
        this.messager = messager;
    }

    public static HandlerLibrary load(Messager messager) {
        HandlerLibrary library = new HandlerLibrary(messager);
        try {
            HandlerLibrary.loadAnnotationHandlers(library);
            HandlerLibrary.loadVisitorHandlers(library);
        }
        catch (IOException e) {
            System.err.println("Lombok isn't running due to misconfigured SPI files: " + e);
        }
        return library;
    }

    private static void loadAnnotationHandlers(HandlerLibrary lib) throws IOException {
        for (JavacAnnotationHandler handler : SpiLoadUtil.findServices(JavacAnnotationHandler.class, JavacAnnotationHandler.class.getClassLoader())) {
            Class<? extends Annotation> annotationClass;
            AnnotationHandlerContainer<? extends Annotation> container = new AnnotationHandlerContainer<Annotation>(handler, annotationClass = SpiLoadUtil.findAnnotationClass(handler.getClass(), JavacAnnotationHandler.class));
            if (lib.annotationHandlers.put(((AnnotationHandlerContainer)container).annotationClass.getName(), container) != null) {
                lib.javacWarning("Duplicate handlers for annotation type: " + ((AnnotationHandlerContainer)container).annotationClass.getName());
            }
            lib.typeLibrary.addType(((AnnotationHandlerContainer)container).annotationClass.getName());
        }
    }

    private static void loadVisitorHandlers(HandlerLibrary lib) throws IOException {
        for (JavacASTVisitor visitor : SpiLoadUtil.findServices(JavacASTVisitor.class, JavacASTVisitor.class.getClassLoader())) {
            lib.visitorHandlers.add(visitor);
        }
    }

    public void javacWarning(String message) {
        this.javacWarning(message, null);
    }

    public void javacWarning(String message, Throwable t) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, message + (t == null ? "" : ": " + t));
    }

    public void javacError(String message) {
        this.javacError(message, null);
    }

    public void javacError(String message, Throwable t) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, message + (t == null ? "" : ": " + t));
        if (t != null) {
            t.printStackTrace();
        }
    }

    public boolean handleAnnotation(JCTree.JCCompilationUnit unit, JavacNode node, JCTree.JCAnnotation annotation) {
        TypeResolver resolver = new TypeResolver(this.typeLibrary, node.getPackageDeclaration(), node.getImportStatements());
        String rawType = annotation.annotationType.toString();
        boolean handled = false;
        for (String fqn : resolver.findTypeMatches(node, rawType)) {
            AnnotationHandlerContainer<?> container;
            boolean isPrintAST = fqn.equals(PrintAST.class.getName());
            if (isPrintAST == this.skipPrintAST || (container = this.annotationHandlers.get(fqn)) == null) continue;
            try {
                handled |= container.handle(node);
            }
            catch (AnnotationValues.AnnotationValueDecodeFail fail) {
                fail.owner.setError(fail.getMessage(), fail.idx);
            }
            catch (Throwable t) {
                String sourceName = "(unknown).java";
                if (unit != null && unit.sourcefile != null) {
                    sourceName = unit.sourcefile.getName();
                }
                this.javacError(String.format("Lombok annotation handler %s failed on " + sourceName, ((AnnotationHandlerContainer)container).handler.getClass()), t);
            }
        }
        return handled;
    }

    public void callASTVisitors(JavacAST ast) {
        for (JavacASTVisitor visitor : this.visitorHandlers) {
            try {
                ast.traverse(visitor);
            }
            catch (Throwable t) {
                this.javacError(String.format("Lombok visitor handler %s failed", visitor.getClass()), t);
            }
        }
    }

    public void skipPrintAST() {
        this.skipPrintAST = true;
    }

    public void skipAllButPrintAST() {
        this.skipPrintAST = false;
    }

    private static class AnnotationHandlerContainer<T extends Annotation> {
        private JavacAnnotationHandler<T> handler;
        private Class<T> annotationClass;

        AnnotationHandlerContainer(JavacAnnotationHandler<T> handler, Class<T> annotationClass) {
            this.handler = handler;
            this.annotationClass = annotationClass;
        }

        public boolean handle(JavacNode node) {
            return this.handler.handle(Javac.createAnnotation(this.annotationClass, node), (JCTree.JCAnnotation)node.get(), node);
        }
    }
}

