#!/usr/bin/env python
# encoding: utf-8
"""
setup.py

distutil file for rubberband wrapper

If the dylib isn't loading correctly, make sure the path to it is in 
the $DYLD_LIBRARY_PATH enviromental variable.
the include_dirs must point to the locations of the following h files:
	python.h
	arrayobject.h (numpy)
	audioDB.h
	
	the directory where your system's numpy inclde files can be found is autogenerated, but I sort of made up the method. 
	I'm sure there's a better way and this has only been tested on my system.
	
Created by Benjamin Fields on 2009-09-04.
Copyright (c) 2009 Goldsmith University of London. All rights reserved.

"""

from distutils.core import setup, Extension
from  numpy import __path__ as numpyBase
from os.path import join

module1 = Extension('_pyadb',
					define_macros = [('MAJOR_VERSION', '0'),
                                     ('MINOR_VERSION', '2')],
                    include_dirs = ['/opt/local/include', '../../', join(numpyBase[0],'core/include')],
                    libraries = ['audioDB'],
                    library_dirs = ['../../', '/opt/local/lib'],
                    sources = ['pyadbmodule.c'])
					

setup (name = 'pyadb',
       version = '0.2a',
       description = 'AudioDB is a vector based similiarity and matching tool.',
	   maintainer = 'Benjamin Fields',
	   maintainer_email = 'b.fields@gold.ac.uk',
       ext_modules = [module1],
       py_modules=['pyadb'],
)

