#!/usr/bin/env python
# encoding: utf-8
"""
gen_results.py

Created by Thomas Walters on 2010-09-12.
"""

import sys
import getopt
import re


help_message = '''
Write out all the results for a run of the
syllable recognition experiment. Expected input is a 'misclassificaions'
file of the type generated by run_test_instance.sh, along with the locations
of files containing the training talkers and all the talkers that the system
was tested on.

Arguments:
-i --input_file
-t --train_talkers
-s --test_talkers
-c --value_count
-p --spoke_pattern
'''

class Usage(Exception):
  def __init__(self, msg):
    self.msg = msg


def main(argv=None):
  if argv is None:
    argv = sys.argv
  try:
    try:
      opts, args = getopt.getopt(argv[1:], "hi:t:s:o:c:p:v",
                                 ["help", "input_file=", "train_talkers=",
                                  "test_talkers=",
                                  "value_count=", "spoke_pattern="])
    except getopt.error, msg:
      raise Usage(msg)
  
    # defaults
    input_file = "misclassified_syllables_iteration_15"
    train_talkers = "training_talkers"
    test_talkers = "testing_talkers"
    output_filename = "results.txt"
    total_value_count = 185
    spoke_pattern_file = "spoke_pattern.txt"
    
    # option processing
    for option, value in opts:
      if option == "-v":
        verbose = True
      if option in ("-h", "--help"):
        raise Usage(help_message)
      if option in ("-i", "--input_file"):
        input_file = value
      if option in ("-t", "--train_talkers"):
        train_talkers = value
      if option in ("-s", "--test_talkers"):
        test_talkers = value
      if option in ("-c", "--value_count"):
        total_value_count = int(value)
      if option in ("-p", "--spoke_pattern"):
        spoke_pattern_file = value
  
  except Usage, err:
    print >> sys.stderr, sys.argv[0].split("/")[-1] + ": " + str(err.msg)
    print >> sys.stderr, "\t for help use --help"
    return 2
    
  results = dict()
  f = open(input_file, 'r')
  for line in f:
    values = line.strip().split(' ')
    results[values[1]]=100*(1-float(values[0])/total_value_count)
 	
  f = open(test_talkers, 'r')
  test_talkers_list = f.readlines()
  f.close()

  f = open(train_talkers, 'r')
  train_talkers_list = f.readlines()
  f.close()

  spoke_pattern = []
  f = open(spoke_pattern_file, 'r')
  for line in f:
	spoke_pattern.append(line.strip().split(' '))

  all_talkers_list = []
  all_talkers_list.extend(train_talkers_list)
  all_talkers_list.extend(test_talkers_list)

  # Here I make the rather rash assumption that the model was tested on all talkers
  # this should be true if the training and testing was done using my scripts.
  for t in all_talkers_list:
	results.setdefault(t.strip(), 100.0)

  total_score = 0.0
  element_count = 0
  for t in train_talkers_list:
	total_score += results[t.strip()]
	element_count += 1
  score = total_score / element_count
  print ("# Score on training talkers: %.1f%%" % score)

  total_score = 0.0
  element_count = 0
  for t in all_talkers_list:
	total_score += results[t.strip()]
	element_count += 1
  score = total_score / element_count
  print ("# Score on all talkers: %.1f%%" % score)

  total_score = 0.0
  element_count = 0
  for t in test_talkers_list:
	total_score += results[t.strip()]
	element_count += 1
  score = total_score / element_count
  print ("# Score on test talkers: %.1f%%" % score)

  score = results[spoke_pattern[0][0]]
  print ("# Score on central talker: %.1f" % score)

  for s in xrange(1,9):
	print ("# Results for spoke %d" % s)
	for p in xrange(0, 7):
	  score = results[spoke_pattern[s][p]]
	  m = re.match('(.*)p(.*)s', spoke_pattern[s][p])
	  gpr = m.group(1)
	  vtl=m.group(2)
	  print ("%s %s %s" % (gpr, vtl, score))

if __name__ == "__main__":
  sys.exit(main())
